
### RTM - Requirements

<p>This page displays the Requirements Traceability Matrix (RTM) from the perspective of the requirements. All requirements captured are included, whether or not they are traced. Each requirement may be expanded to show the requirements details as well as the traced test cases.</p>

#### Requirements-components-admin-service

<b><a id="requirement-565" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-565detail" aria-expanded="false">565:&nbsp;Consent Administration Service SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide</a></b>

<div class="collapse" id="req-565detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/STU1.1/components.html#:~:text=cross%20version%20extensions%20SHOULD%20NOT%20be%20used%20on%20R4%20subscriptions%20to%20describe%20any%20elements%20also%20described%20by%20this%20guide">https://hl7.org/fhir/uv/subscriptions-backport/STU1.1/components.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;Not exactly sure how to test this
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

#### Requirements-components-client

<b><a id="requirement-512" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-512detail" aria-expanded="false">512:&nbsp;Consent Client SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide</a></b>

<div class="collapse" id="req-512detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/STU1.1/components.html#:~:text=cross%20version%20extensions%20SHOULD%20NOT%20be%20used%20on%20R4%20subscriptions%20to%20describe%20any%20elements%20also%20described%20by%20this%20guide">https://hl7.org/fhir/uv/subscriptions-backport/STU1.1/components.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;Not exactly sure how to test this
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

#### Requirements-capstmt-admin-service

<b><a id="requirement-1" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-1detail" aria-expanded="false">1:&nbsp;Consent Administration Service SHALL implement the server CapabilityStatement</a></b>

<div class="collapse" id="req-1detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/artifacts.html#:~:text=Capabilities%20required%20for%20a%20server%20system%20receiving%20consents.">https://build.fhir.org/ig/HL7/fhir-consent-management/artifacts.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Does this mean a conforming system has to reference the "requirements" CS here, or could they just have their own CS that happens to be compatible?
Also, what test should this be traced to? I'm thinking this traces to test procedure that ensures the right complement of tests are applied to a given system.
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-2" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-2detail" aria-expanded="false">2:&nbsp;Consent Administration Service SHALL support JSON FHIR</a></b>

<div class="collapse" id="req-2detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22%20%3A%20%5B-,%22json%22,-%2C%0A%20%20%20%20%22xml%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;- Plan is to have JSON and XML flavors of all tests, but explicitly tracing each of those back to these requirements is probably not necessary.
  * <b>Traced Test Cases:</b>
    * [136: Obtain server CapabilityStatement - JSON](rtm_test_cases.html#testcase-136)
</div>
</div>

<b><a id="requirement-34" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-34detail" aria-expanded="false">34:&nbsp;Consent Administration Service SHALL support XML FHIR</a></b>

<div class="collapse" id="req-34detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22json%22%2C-,%22xml%22,-%5D%2C%0A%20%20%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;- Plan is to have JSON and XML flavors of all tests, but explicitly tracing each of those back to these requirements is probably not necessary.
  * <b>Traced Test Cases:</b>
    * [137: Obtain server CapabilityStatement - XML](rtm_test_cases.html#testcase-137)
</div>
</div>

<b><a id="requirement-43" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-43detail" aria-expanded="false">43:&nbsp;Consent Administration Service SHALL support Consent resource</a></b>

<div class="collapse" id="req-43detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22mode%22%20%3A%20%22server,type%22%20%3A%20%22Consent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-35" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-35detail" aria-expanded="false">35:&nbsp;Consent Administration Service SHALL support Consent resources that conform to FASTConsent profile</a></b>

<div class="collapse" id="req-35detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-331" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-331detail" aria-expanded="false">331:&nbsp;Consent Administration Service SHALL mark with profile assertions Consent resources that conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-331detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of,by%20the%20profile)">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile. Not marking as fully tested because I will continue to need to trace this to every transaction that applies.
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [166: Search for Consent by FASTConsent profile - JSON](rtm_test_cases.html#testcase-166)
    * [167: Search for Consent by FASTConsent profile - XML](rtm_test_cases.html#testcase-167)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [67: Workflow: Utilize Consent For Disclosure](rtm_test_cases.html#testcase-67)
</div>
</div>

<b><a id="requirement-332" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-332detail" aria-expanded="false">332:&nbsp;Consent Administration Service SHALL support searching by the _profile parameter for Consent resources that conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-332detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of%20resources,for%20the%20declared%20profiles">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile
  * <b>Traced Test Cases:</b>
    * [166: Search for Consent by FASTConsent profile - JSON](rtm_test_cases.html#testcase-166)
    * [167: Search for Consent by FASTConsent profile - XML](rtm_test_cases.html#testcase-167)
</div>
</div>

<b><a id="requirement-36" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-36detail" aria-expanded="false">36:&nbsp;Consent Administration Service SHALL support Consent read</a></b>

<div class="collapse" id="req-36detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B-,%22code%22%20%3A%20%22read%22,-%7D%0A%20%20%20%20%20%20%20%20%20%20%5D%2C">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-37" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-37detail" aria-expanded="false">37:&nbsp;Consent Administration Service SHALL support Consent search</a></b>

<div class="collapse" id="req-37detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsent%22%0A%20%20%20%20%20%20%20%20%20%20%5D%2C%0A%20%20%20%20%20%20%20%20%20%20%22interaction%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22code%22%20%3A%20%22search%2Dtype%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-199" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-199detail" aria-expanded="false">199:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentController</a></b>

<div class="collapse" id="req-199detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[472:&nbsp;SearchParameter FASTConsentController](rtm_requirements.html#requirement-472)
  * <b>Traced Test Cases:</b>
    * [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144)
    * [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-72" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-72detail" aria-expanded="false">72:&nbsp;Consent Administration Service SHALL support Consent search by date</a></b>

<div class="collapse" id="req-72detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,type%22%20%3A%20%22date%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [146: Search for Consent by date - JSON](rtm_test_cases.html#testcase-146)
    * [147: Search for Consent by date - XML](rtm_test_cases.html#testcase-147)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-38" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-38detail" aria-expanded="false">38:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentGrantee</a></b>

<div class="collapse" id="req-38detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,grantee%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[473:&nbsp;SearchParameter FASTConsentGrantee](rtm_requirements.html#requirement-473)
  * <b>Notes:</b>&nbsp;Missing corresponding req in Tech spec 6.2.3.4
  * <b>Traced Test Cases:</b>
    * [148: Search for Consent by FASTConsentGrantee - JSON](rtm_test_cases.html#testcase-148)
    * [149: Search for Consent by FASTConsentGrantee - XML](rtm_test_cases.html#testcase-149)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-200" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-200detail" aria-expanded="false">200:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentManager</a></b>

<div class="collapse" id="req-200detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,manager%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[474:&nbsp;SearchParameter FASTConsentManager](rtm_requirements.html#requirement-474)
  * <b>Traced Test Cases:</b>
    * [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150)
    * [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-39" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-39detail" aria-expanded="false">39:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentOrganizationId</a></b>

<div class="collapse" id="req-39detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[475:&nbsp;SearchParameter FASTConsentOrganizationId](rtm_requirements.html#requirement-475)
  * <b>Notes:</b>&nbsp;Matches identifier of grantee, manager, controller or the provision.actor.reference
Missing corresponding req in Tech spec 6.2.3.4
  * <b>Traced Test Cases:</b>
    * [152: Search for Consent by FASTConsentOrganizationId - JSON](rtm_test_cases.html#testcase-152)
    * [153: Search for Consent by FASTConsentOrganizationId - XML](rtm_test_cases.html#testcase-153)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-40" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-40detail" aria-expanded="false">40:&nbsp;Consent Administration Service SHALL support Consent search by patient</a></b>

<div class="collapse" id="req-40detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,patient%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [154: Search for Consent by patient - JSON](rtm_test_cases.html#testcase-154)
    * [155: Search for Consent by patient - XML](rtm_test_cases.html#testcase-155)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-368" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-368detail" aria-expanded="false">368:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentPatientId</a></b>

<div class="collapse" id="req-368detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,patientId%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[476:&nbsp;SearchParameter FASTConsentPatientId](rtm_requirements.html#requirement-476)
  * <b>Notes:</b>&nbsp;Matches patient.identifier or patient.extension additionalIdentifier
Missing corresponding req in Tech spec 6.2.3.4
  * <b>Traced Test Cases:</b>
    * [156: Search for Consent by FASTConsentPatientId - JSON](rtm_test_cases.html#testcase-156)
    * [157: Search for Consent by FASTConsentPatientId - XML](rtm_test_cases.html#testcase-157)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-42" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-42detail" aria-expanded="false">42:&nbsp;Consent Administration Service SHALL support Consent search by scope</a></b>

<div class="collapse" id="req-42detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,scope%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [158: Search for Consent by scope - JSON](rtm_test_cases.html#testcase-158)
    * [159: Search for Consent by scope - XML](rtm_test_cases.html#testcase-159)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-41" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-41detail" aria-expanded="false">41:&nbsp;Consent Administration Service SHALL support Consent search by status</a></b>

<div class="collapse" id="req-41detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,status%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [160: Search for Consent by status - JSON](rtm_test_cases.html#testcase-160)
    * [161: Search for Consent by status - XML](rtm_test_cases.html#testcase-161)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-46" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-46detail" aria-expanded="false">46:&nbsp;Consent Administration Service SHALL support $fileConsent operation against Consent resource</a></b>

<div class="collapse" id="req-46detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,consent%2Dmanagement/OperationDefinition/file%2Dconsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[463:&nbsp;OperationDefinition FileConsent](rtm_requirements.html#requirement-463)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-374" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-374detail" aria-expanded="false">374:&nbsp;Consent Administration Service SHALL support $revokeConsent operation against Consent resource</a></b>

<div class="collapse" id="req-374detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,consent%2Dmanagement/OperationDefinition/revoke%2Dconsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[466:&nbsp;OperationDefinition RevokeConsent](rtm_requirements.html#requirement-466)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-661" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-661detail" aria-expanded="false">661:&nbsp;Consent Administration Service SHALL support Subscription resource</a></b>

<div class="collapse" id="req-661detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22resource%22,%3A%20%22Subscription%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
</div>
</div>

<b><a id="requirement-377" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-377detail" aria-expanded="false">377:&nbsp;Consent Administration Service SHALL support Consent subscriptions as defined by the FASTConsentSubscriptionTopic for FHIR R4 with Subscriptions Backport</a></b>

<div class="collapse" id="req-377detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22type%22%20%3A%20%22Subscription%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-378" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-378detail" aria-expanded="false">378:&nbsp;Consent Administration Service SHALL support Subscription create</a></b>

<div class="collapse" id="req-378detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22code%22%20%3A%20%22create%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;For now, testing limited to the topic declared in the CapStmt
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-379" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-379detail" aria-expanded="false">379:&nbsp;Consent Administration Service SHALL support Subscription update</a></b>

<div class="collapse" id="req-379detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22code%22%20%3A%20%22update%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [306: Workflow: Update a Subscription - rest-hook](rtm_test_cases.html#testcase-306)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-380" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-380detail" aria-expanded="false">380:&nbsp;Consent Administration Service SHALL support Subscription delete</a></b>

<div class="collapse" id="req-380detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22code%22%20%3A%20%22delete%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-415" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-415detail" aria-expanded="false">415:&nbsp;Consent Administration Service SHALL support $recordDisclosure operation against AuditEvent resource</a></b>

<div class="collapse" id="req-415detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22,OperationDefinition/record%2Ddisclosure%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[445:&nbsp;The RecordDisclosure operation is invoked as [base]/AuditEvent/$recordDisclosure](rtm_requirements.html#requirement-445)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-397" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-397detail" aria-expanded="false">397:&nbsp;Consent Administration Service SHALL support AuditEvent resource</a></b>

<div class="collapse" id="req-397detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22resource%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22AuditEvent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-398" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-398detail" aria-expanded="false">398:&nbsp;Consent Administration Service SHALL support AuditEvent resources that conform to FASTConsentAuditEvent profile</a></b>

<div class="collapse" id="req-398detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsentAuditEvent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-399" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-399detail" aria-expanded="false">399:&nbsp;Consent Administration Service SHALL mark with profile assertions AuditEvent resources that conform to the FASTConsentAuditEvent profile</a></b>

<div class="collapse" id="req-399detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of,by%20the%20profile)">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile. Not marking as fully tested because I will continue to need to trace this to every transaction that applies.
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168)
    * [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169)
</div>
</div>

<b><a id="requirement-400" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-400detail" aria-expanded="false">400:&nbsp;Consent Administration Service SHALL support searching by the _profile parameter for AuditEvent resources that conform to the FASTConsentAuditEvent profile</a></b>

<div class="collapse" id="req-400detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of%20resources,for%20the%20declared%20profiles">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile
  * <b>Traced Test Cases:</b>
    * [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168)
    * [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169)
</div>
</div>

<b><a id="requirement-404" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-404detail" aria-expanded="false">404:&nbsp;Consent Administration Service SHALL support AuditEvent read</a></b>

<div class="collapse" id="req-404detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent,code%22%20%3A%20%22read%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-406" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-406detail" aria-expanded="false">406:&nbsp;Consent Administration Service SHALL support AuditEvent search</a></b>

<div class="collapse" id="req-406detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsentAuditEvent%22%0A%20%20%20%20%20%20%20%20%20%20%5D%2C%0A%20%20%20%20%20%20%20%20%20%20%22interaction%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22code%22%20%3A%20%22search%2Dtype%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-409" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-409detail" aria-expanded="false">409:&nbsp;Consent Administration Service SHALL support AuditEvent search by FASTAuditEventConsent</a></b>

<div class="collapse" id="req-409detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent,type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162)
    * [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-412" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-412detail" aria-expanded="false">412:&nbsp;Consent Administration Service SHALL support AuditEvent search by patient</a></b>

<div class="collapse" id="req-412detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,patient%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164)
    * [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-505" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-505detail" aria-expanded="false">505:&nbsp;Consent Administration Service SHALL support Subscription read</a></b>

<div class="collapse" id="req-505detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=A%20Server%20SHALL%20be%20capable%20of%20returning%20a%20Subscription%20resource%20using%3A%20GET%20%5Bbase%5D/Subscription/%5Bid%5D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
</div>
</div>

<b><a id="requirement-503" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-503detail" aria-expanded="false">503:&nbsp;Consent Administration Service SHOULD support Subscription write via POST or PUT</a></b>

<div class="collapse" id="req-503detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=A%20Server%20SHOULD%20be%20capable%20of%20creating%20a%20Subscription%20resource%20using%20either%3A%20POST%20%5Bbase%5D/Subscription%20or%20PUT%20%5Bbase%5D/Subscription/%5Bid%5D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;- "After POSTing the subscription, the client parses the Location header and saves the new Subscription's logical id for use in subsequent operations." - implies server should always return Location
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [305: Workflow: Create a Subscription - rest-hook PUT](rtm_test_cases.html#testcase-305)
</div>
</div>

<b><a id="requirement-509" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-509detail" aria-expanded="false">509:&nbsp;Consent Administration Service SHOULD support Subscription update via PUT or PATCH</a></b>

<div class="collapse" id="req-509detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=A%20Server%20SHOULD%20be%20capable%20of%20modifying%20a%20Subscription%20resource%20using%20either%3A%20PUT%20%5Bbase%5D/Subscription/%5Bid%5D%20or%20PATCH%20%5Bbase%5D/Subscription/%5Bid%5D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;The CapStmt and the rendered page disagree - the raw CS does not include patch and the page does. Not testing patch at this time.
  * <b>Traced Test Cases:</b>
    * [306: Workflow: Update a Subscription - rest-hook](rtm_test_cases.html#testcase-306)
    * [307: Workflow: Update a Subscription - rest-hook PATCH](rtm_test_cases.html#testcase-307)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-510" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-510detail" aria-expanded="false">510:&nbsp;Consent Administration Service SHOULD support Subscription delete</a></b>

<div class="collapse" id="req-510detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=A%20Server%20SHOULD%20be%20capable%20of%20modifying%20a%20Subscription%20resource%20using%20either%3A%20PUT%20%5Bbase%5D/Subscription/%5Bid%5D%20or%20PATCH%20%5Bbase%5D/Subscription/%5Bid%5D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Traced Test Cases:</b>
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-511" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-511detail" aria-expanded="false">511:&nbsp;Consent Administration Service SHOULD support Subscription search</a></b>

<div class="collapse" id="req-511detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=A%20Server%20SHOULD%20be%20capable%20of%20modifying%20a%20Subscription%20resource%20using%20either%3A%20PUT%20%5Bbase%5D/Subscription/%5Bid%5D%20or%20PATCH%20%5Bbase%5D/Subscription/%5Bid%5D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;Not testing search at this time
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-602" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-602detail" aria-expanded="false">602:&nbsp;Consent Administration Service SHALL support Subscription search by url</a></b>

<div class="collapse" id="req-602detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json#:~:text=%22searchParam%22%20%3A%20%5B%7B%0D%0A%20%20%20%20%20%20%20%20%22extension%22%20%3A%20%5B%7B%0D%0A%20%20%20%20%20%20%20%20%20%20%22url,url%22%2C%0D%0A%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22uri%22%0D%0A%20%20%20%20%20%20%7D%2C">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Not testing search at this time. Also, the raw CapStmt (linked) and the rendered page for the CapStmt disagree: the raw says SHALL, the page says SHOULD. See: https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=Search%20Parameter%20Summary,uri
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-604" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-604detail" aria-expanded="false">604:&nbsp;Consent Administration Service SHOULD support Subscription search by status</a></b>

<div class="collapse" id="req-604detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=Search%20Parameter%20Summary,token">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;Not testing search at this time
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-508" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-508detail" aria-expanded="false">508:&nbsp;Consent Administration Service SHALL support $status operation against Subscription resource</a></b>

<div class="collapse" id="req-508detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html#:~:text=SHALL%20support%20the%20%24status%20operation">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [266: Operation: Get Subscription Status](rtm_test_cases.html#testcase-266)
</div>
</div>

<b><a id="requirement-694" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-694detail" aria-expanded="false">694:&nbsp;Consent Administration Service MAY support $events operation against Subscription resource</a></b>

<div class="collapse" id="req-694detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json#:~:text=%22extension%22%20%3A%20%5B%7B%0D%0A%20%20%20%20%20%20%20%20%20%20%22url%22%20%3A%20%22http%3A//hl7.org/fhir/StructureDefinition/capabilitystatement%2Dexpectation%22%2C%0D%0A%20%20%20%20%20%20%20%20%20%20%22valueCode%22%20%3A%20%22MAY,http%3A//hl7.org/fhir/uv/subscriptions%2Dbackport/OperationDefinition/backport%2Dsubscription%2Devents%22">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json</a>
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Notes:</b>&nbsp;Not testing at this time
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-695" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-695detail" aria-expanded="false">695:&nbsp;Consent Administration Service MAY support $get-ws-binding-token operation against Subscription resource</a></b>

<div class="collapse" id="req-695detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json#:~:text=backport%2Dsubscription%2Devents%22%0D%0A%20%20%20%20%20%20%7D%2C%0D%0A%20%20%20%20%20%20%7B-,%22extension%22%20%3A%20%5B%7B%0D%0A%20%20%20%20%20%20%20%20%20%20%22url%22%20%3A%20%22http%3A//hl7.org/fhir/StructureDefinition/capabilitystatement%2Dexpectation%22%2C%0D%0A%20%20%20%20%20%20%20%20%20%20%22valueCode%22%20%3A%20%22MAY,fhir/uv/subscriptions%2Dbackport/OperationDefinition/backport%2Dsubscription%2Dget%2Dws%2Dbinding%2Dtoken%22,-%7D%5D%0D%0A%20%20%20%20%7D%5D%0D%0A%20%20%7D%5D%0D%0A%7D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json</a>
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Notes:</b>&nbsp;Not testing at this time
  * <b>Traced Test Cases:</b>
</div>
</div>

<b><a id="requirement-517" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-517detail" aria-expanded="false">517:&nbsp;Consent Administration Service SHALL support Subscription resources that conform to BackportSubscription profile</a></b>

<div class="collapse" id="req-517detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json#:~:text=%22resource%22%20%3A%20%5B%7B%0D%0A%20%20%20%20%20%20%22extension%22%20%3A%20%5B%7B%0D%0A%20%20%20%20%20%20%20%20%22url,StructureDefinition/backport%2Dsubscription%22%5D">https://hl7.org/fhir/uv/subscriptions-backport/CapabilityStatement-backport-subscription-server-r4.json</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-514" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-514detail" aria-expanded="false">514:&nbsp;Consent Administration Service SHALL mark with profile assertions Subscription resources that conform to the BackportSubscription profile</a></b>

<div class="collapse" id="req-514detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of,by%20the%20profile)">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile. Not marking as fully tested because I will continue to need to trace this to every transaction that applies.
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168)
    * [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169)
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-515" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-515detail" aria-expanded="false">515:&nbsp;Consent Administration Service SHALL support searching by the _profile parameter for Subscription resources that conform to the BackportSubscription profile</a></b>

<div class="collapse" id="req-515detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of%20resources,for%20the%20declared%20profiles">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile
  * <b>Traced Test Cases:</b>
    * [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168)
    * [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169)
</div>
</div>

#### Requirements-capstmt-client

<b><a id="requirement-48" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-48detail" aria-expanded="false">48:&nbsp;Consent Client SHALL implement the client CapabilityStatement</a></b>

<div class="collapse" id="req-48detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/artifacts.html#:~:text=Capabilities%20required%20for%20a%20server%20system%20receiving%20consents.">https://build.fhir.org/ig/HL7/fhir-consent-management/artifacts.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;- Interpreting this as: a client doesn't necessarily have to maintain and make available a client CS, but does have to implement the functionality therein. So specific requirements from the CS are traced to tests that exercise them.
- Does this mean a conforming system has to reference the "requirements" CS here, or could they just have their own CS that happens to be compatible?
  * <b>Traced Test Cases:</b>
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-49" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-49detail" aria-expanded="false">49:&nbsp;Consent Client SHALL support JSON FHIR</a></b>

<div class="collapse" id="req-49detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22%20%3A%20%5B-,%22json%22,-%2C%0A%20%20%20%20%22xml%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;- Plan is to have JSON and XML flavors of all tests, but explicitly tracing each of those back to these requirements is probably not necessary.
  * <b>Traced Test Cases:</b>
    * [136: Obtain server CapabilityStatement - JSON](rtm_test_cases.html#testcase-136)
    * [138: Test client CapabilityStatement - JSON](rtm_test_cases.html#testcase-138)
</div>
</div>

<b><a id="requirement-50" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-50detail" aria-expanded="false">50:&nbsp;Consent Client SHALL support XML FHIR</a></b>

<div class="collapse" id="req-50detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22json%22%2C-,%22xml%22,-%5D%2C%0A%20%20%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;- Plan is to have JSON and XML flavors of all tests, but explicitly tracing each of those back to these requirements is probably not necessary.
  * <b>Traced Test Cases:</b>
    * [137: Obtain server CapabilityStatement - XML](rtm_test_cases.html#testcase-137)
    * [139: Test client CapabilityStatement - XML](rtm_test_cases.html#testcase-139)
</div>
</div>

<b><a id="requirement-333" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-333detail" aria-expanded="false">333:&nbsp;Consent Client SHALL support Consent resource</a></b>

<div class="collapse" id="req-333detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html#:~:text=%22resource%22%20%3A%20%5B,type%22%20%3A%20%22Consent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentAdministrativeServerCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-52" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-52detail" aria-expanded="false">52:&nbsp;Consent Client SHALL support Consent resources that conform to FASTConsent profile</a></b>

<div class="collapse" id="req-52detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-334" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-334detail" aria-expanded="false">334:&nbsp;Consent Client SHALL mark with profile assertions Consent resources that conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-334detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of,by%20the%20profile)">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile.  Not marking as fully tested because I will continue to need to trace this to every transaction that applies.
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-56" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-56detail" aria-expanded="false">56:&nbsp;Consent Client SHALL support Consent read</a></b>

<div class="collapse" id="req-56detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsent%22%0A%20%20%20%20%20%20%20%20%20%20%5D%2C%0A%20%20%20%20%20%20%20%20%20%20%22interaction%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22code%22%20%3A%20%22search%2Dtype%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22code%22%20%3A%20%22read%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-57" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-57detail" aria-expanded="false">57:&nbsp;Consent Client SHALL support Consent search</a></b>

<div class="collapse" id="req-57detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsent%22%0A%20%20%20%20%20%20%20%20%20%20%5D%2C%0A%20%20%20%20%20%20%20%20%20%20%22interaction%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22code%22%20%3A%20%22search%2Dtype%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-58" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-58detail" aria-expanded="false">58:&nbsp;Consent Client SHALL support Consent search by FASTConsentController</a></b>

<div class="collapse" id="req-58detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[472:&nbsp;SearchParameter FASTConsentController](rtm_requirements.html#requirement-472)
  * <b>Traced Test Cases:</b>
    * [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144)
    * [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-369" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-369detail" aria-expanded="false">369:&nbsp;Consent Client SHALL support Consent search by date</a></b>

<div class="collapse" id="req-369detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,type%22%20%3A%20%22date%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [146: Search for Consent by date - JSON](rtm_test_cases.html#testcase-146)
    * [147: Search for Consent by date - XML](rtm_test_cases.html#testcase-147)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-370" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-370detail" aria-expanded="false">370:&nbsp;Consent Client SHALL support Consent search by FASTConsentGrantee</a></b>

<div class="collapse" id="req-370detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,grantee%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[473:&nbsp;SearchParameter FASTConsentGrantee](rtm_requirements.html#requirement-473)
  * <b>Traced Test Cases:</b>
    * [148: Search for Consent by FASTConsentGrantee - JSON](rtm_test_cases.html#testcase-148)
    * [149: Search for Consent by FASTConsentGrantee - XML](rtm_test_cases.html#testcase-149)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-371" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-371detail" aria-expanded="false">371:&nbsp;Consent Client SHALL support Consent search by FASTConsentManager</a></b>

<div class="collapse" id="req-371detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,manager%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[474:&nbsp;SearchParameter FASTConsentManager](rtm_requirements.html#requirement-474)
  * <b>Traced Test Cases:</b>
    * [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150)
    * [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-59" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-59detail" aria-expanded="false">59:&nbsp;Consent Client SHALL support Consent search by FASTConsentOrganizationId</a></b>

<div class="collapse" id="req-59detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[475:&nbsp;SearchParameter FASTConsentOrganizationId](rtm_requirements.html#requirement-475)
  * <b>Notes:</b>&nbsp;Matches identifier of grantee, manager, controller or the provision.actor.reference
  * <b>Traced Test Cases:</b>
    * [152: Search for Consent by FASTConsentOrganizationId - JSON](rtm_test_cases.html#testcase-152)
    * [153: Search for Consent by FASTConsentOrganizationId - XML](rtm_test_cases.html#testcase-153)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-60" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-60detail" aria-expanded="false">60:&nbsp;Consent Client SHALL support Consent search by patient</a></b>

<div class="collapse" id="req-60detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,patient%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [154: Search for Consent by patient - JSON](rtm_test_cases.html#testcase-154)
    * [155: Search for Consent by patient - XML](rtm_test_cases.html#testcase-155)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-372" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-372detail" aria-expanded="false">372:&nbsp;Consent Client SHALL support Consent search by FASTConsentPatientId</a></b>

<div class="collapse" id="req-372detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,patientId%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[476:&nbsp;SearchParameter FASTConsentPatientId](rtm_requirements.html#requirement-476)
  * <b>Notes:</b>&nbsp;Matches patient.identifier or patient.extension additionalIdentifier
  * <b>Traced Test Cases:</b>
    * [156: Search for Consent by FASTConsentPatientId - JSON](rtm_test_cases.html#testcase-156)
    * [157: Search for Consent by FASTConsentPatientId - XML](rtm_test_cases.html#testcase-157)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-47" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-47detail" aria-expanded="false">47:&nbsp;Consent Client SHALL support Consent search by scope</a></b>

<div class="collapse" id="req-47detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,scope%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [158: Search for Consent by scope - JSON](rtm_test_cases.html#testcase-158)
    * [159: Search for Consent by scope - XML](rtm_test_cases.html#testcase-159)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-61" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-61detail" aria-expanded="false">61:&nbsp;Consent Client SHALL support Consent search by status</a></b>

<div class="collapse" id="req-61detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,status%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22token%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [160: Search for Consent by status - JSON](rtm_test_cases.html#testcase-160)
    * [161: Search for Consent by status - XML](rtm_test_cases.html#testcase-161)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-53" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-53detail" aria-expanded="false">53:&nbsp;Consent Client SHALL support $fileConsent operation against Consent resource</a></b>

<div class="collapse" id="req-53detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,consent%2Dmanagement/OperationDefinition/file%2Dconsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[463:&nbsp;OperationDefinition FileConsent](rtm_requirements.html#requirement-463)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-376" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-376detail" aria-expanded="false">376:&nbsp;Consent Client SHALL support $revokeConsent operation against Consent resource</a></b>

<div class="collapse" id="req-376detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22Consent,consent%2Dmanagement/OperationDefinition/revoke%2Dconsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[466:&nbsp;OperationDefinition RevokeConsent](rtm_requirements.html#requirement-466)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-381" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-381detail" aria-expanded="false">381:&nbsp;Consent Client SHALL support Consent subscriptions as defined by the FASTConsentSubscriptionTopic for FHIR R4 with Subscriptions Backport</a></b>

<div class="collapse" id="req-381detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22type%22%20%3A%20%22Subscription%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-382" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-382detail" aria-expanded="false">382:&nbsp;Consent Client SHALL support Subscription create</a></b>

<div class="collapse" id="req-382detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22code%22%20%3A%20%22create%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-383" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-383detail" aria-expanded="false">383:&nbsp;Consent Client SHALL support Subscription update</a></b>

<div class="collapse" id="req-383detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22code%22%20%3A%20%22update%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [306: Workflow: Update a Subscription - rest-hook](rtm_test_cases.html#testcase-306)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-384" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-384detail" aria-expanded="false">384:&nbsp;Consent Client SHALL support Subscription delete</a></b>

<div class="collapse" id="req-384detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22extension%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B,%22code%22%20%3A%20%22delete%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-416" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-416detail" aria-expanded="false">416:&nbsp;Consent Client SHALL support $recordDisclosure operation against AuditEvent resource</a></b>

<div class="collapse" id="req-416detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22,OperationDefinition/record%2Ddisclosure%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[445:&nbsp;The RecordDisclosure operation is invoked as [base]/AuditEvent/$recordDisclosure](rtm_requirements.html#requirement-445)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-401" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-401detail" aria-expanded="false">401:&nbsp;Consent Client SHALL support AuditEvent resource</a></b>

<div class="collapse" id="req-401detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22resource%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22AuditEvent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-402" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-402detail" aria-expanded="false">402:&nbsp;Consent Client SHALL support AuditEvent resources that conform to FASTConsentAuditEvent profile</a></b>

<div class="collapse" id="req-402detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsentAuditEvent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-403" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-403detail" aria-expanded="false">403:&nbsp;Consent Client SHALL mark with profile assertions AuditEvent resources that conform to the FASTConsentAuditEvent profile</a></b>

<div class="collapse" id="req-403detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R4
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/R4/profiling.html#profile-uses:~:text=a%20producer%20of,by%20the%20profile)">https://hl7.org/fhir/R4/profiling.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Base FHIR requirement, applies because of declaring supportedProfile. Not marking as fully tested because I will continue to need to trace this to every transaction that applies.
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-405" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-405detail" aria-expanded="false">405:&nbsp;Consent Client SHALL support AuditEvent read</a></b>

<div class="collapse" id="req-405detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent,code%22%20%3A%20%22read%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-408" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-408detail" aria-expanded="false">408:&nbsp;Consent Client SHALL support AuditEvent search</a></b>

<div class="collapse" id="req-408detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22supportedProfile%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%F0%9F%94%97%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/FASTConsentAuditEvent%22%0A%20%20%20%20%20%20%20%20%20%20%5D%2C%0A%20%20%20%20%20%20%20%20%20%20%22interaction%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22code%22%20%3A%20%22search%2Dtype%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-411" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-411detail" aria-expanded="false">411:&nbsp;Consent Client SHALL support AuditEvent search by FASTAuditEventConsent</a></b>

<div class="collapse" id="req-411detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%22,consent%22%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%22type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162)
    * [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

<b><a id="requirement-414" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-414detail" aria-expanded="false">414:&nbsp;Consent Client SHALL support AuditEvent search by patient</a></b>

<div class="collapse" id="req-414detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html#:~:text=%22type%22%20%3A%20%22AuditEvent,type%22%20%3A%20%22reference%22">https://build.fhir.org/ig/HL7/fhir-consent-management/CapabilityStatement-ConsentClientCapabilities.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164)
    * [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165)
    * [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134)
</div>
</div>

#### Requirements-technical-specification-admin-service

<b><a id="requirement-68" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-68detail" aria-expanded="false">68:&nbsp;Consent Administration Service SHOULD return OperationOutcome with details of which business rules did not allow an operation to be successful if an HTTP status code of 4xx or 5xx is returned</a></b>

<div class="collapse" id="req-68detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=Systems%20SHOULD%20return%20an%20OperationOutcome%20with%20the%20details%20if%20an%20HTTP%20status%20code%20of%204xx%20or%205xx%20is%20returned">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Traced Test Cases:</b>
    * [308: Error: Create a Subscription - rest-hook - unsupported backport-channel-type](rtm_test_cases.html#testcase-308)
    * [309: Error: Create a Subscription - rest-hook - unsupported filter](rtm_test_cases.html#testcase-309)
</div>
</div>

<b><a id="requirement-69" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-69detail" aria-expanded="false">69:&nbsp;Consent Administration Service MAY return OperationOutcome for a successful operation</a></b>

<div class="collapse" id="req-69detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=systems%20MAY%20return%20an%20OperationOutcome%20with%20a%20success%20to%20be%20consistent">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Notes:</b>&nbsp;- Right now, linking to each transaction. But rather than link many generic requirements to every transaction, should I create generic tests that each transaction uses?
•	For now, no, but consider iterating into this. Once everything traces, can consider refactoring traces.
•	An argument for doing this: every time we add a new transaction, we need to add those traces.
  * <b>Traced Test Cases:</b>
    * [1: Read a Consent](rtm_test_cases.html#testcase-1)
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-63" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-63detail" aria-expanded="false">63:&nbsp;Consent Administration Service SHALL support Consent search</a></b>

<div class="collapse" id="req-63detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=consent%20administration%20service%20systems%20SHALL%20support%20searching%20for%20consents">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [2: Search for a Consent](rtm_test_cases.html#testcase-2)
</div>
</div>

<b><a id="requirement-364" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-364detail" aria-expanded="false">364:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentController</a></b>

<div class="collapse" id="req-364detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20support%20searching,controller">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[472:&nbsp;SearchParameter FASTConsentController](rtm_requirements.html#requirement-472)
  * <b>Traced Test Cases:</b>
    * [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144)
    * [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145)
</div>
</div>

<b><a id="requirement-365" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-365detail" aria-expanded="false">365:&nbsp;Consent Administration Service SHALL support Consent search by date</a></b>

<div class="collapse" id="req-365detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20support%20searching,date">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [146: Search for Consent by date - JSON](rtm_test_cases.html#testcase-146)
    * [147: Search for Consent by date - XML](rtm_test_cases.html#testcase-147)
</div>
</div>

<b><a id="requirement-367" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-367detail" aria-expanded="false">367:&nbsp;Consent Administration Service SHALL support Consent search by FASTConsentManager</a></b>

<div class="collapse" id="req-367detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20support%20searching,manager">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[474:&nbsp;SearchParameter FASTConsentManager](rtm_requirements.html#requirement-474)
  * <b>Traced Test Cases:</b>
    * [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150)
    * [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151)
</div>
</div>

<b><a id="requirement-71" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-71detail" aria-expanded="false">71:&nbsp;Consent Administration Service SHALL support Consent search by patient</a></b>

<div class="collapse" id="req-71detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20support%20searching,patient">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [154: Search for Consent by patient - JSON](rtm_test_cases.html#testcase-154)
    * [155: Search for Consent by patient - XML](rtm_test_cases.html#testcase-155)
</div>
</div>

<b><a id="requirement-201" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-201detail" aria-expanded="false">201:&nbsp;Consent Administration Service SHALL support Consent search by scope</a></b>

<div class="collapse" id="req-201detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20support%20searching,scope">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [158: Search for Consent by scope - JSON](rtm_test_cases.html#testcase-158)
    * [159: Search for Consent by scope - XML](rtm_test_cases.html#testcase-159)
</div>
</div>

<b><a id="requirement-73" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-73detail" aria-expanded="false">73:&nbsp;Consent Administration Service SHALL support Consent search by status</a></b>

<div class="collapse" id="req-73detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20support%20searching,status">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [160: Search for Consent by status - JSON](rtm_test_cases.html#testcase-160)
    * [161: Search for Consent by status - XML](rtm_test_cases.html#testcase-161)
</div>
</div>

<b><a id="requirement-62" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-62detail" aria-expanded="false">62:&nbsp;Consent Administration Service SHALL support File Consent operation</a></b>

<div class="collapse" id="req-62detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=a%20consent%20administration%20service%20SHALL%20support%3A,File%20Consent">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#consent-management">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[463:&nbsp;OperationDefinition FileConsent](rtm_requirements.html#requirement-463)
  * <b>Notes:</b>&nbsp;Redundant with CapStmt
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-101" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-101detail" aria-expanded="false">101:&nbsp;Consent Administration Service SHALL support Revoke Consent operation</a></b>

<div class="collapse" id="req-101detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=a%20consent%20administration%20service%20SHALL%20support%3A,Revoke%20Consent">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[466:&nbsp;OperationDefinition RevokeConsent](rtm_requirements.html#requirement-466)
  * <b>Notes:</b>&nbsp;Redundant with CapStmt
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-64" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-64detail" aria-expanded="false">64:&nbsp;Consent Administration Service SHALL support Consent subscriptions (as defined by the FAST Subscription Topic for FHIR R4 with Subscriptions Backport)</a></b>

<div class="collapse" id="req-64detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=consent%20administration%20service%20SHALL%20support%20subscriptions%20to%20allow%20other%20systems%20to%20be%20informed%20when%20consents%20for%20a%20patient%20have%20changed">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Fix: "a consent administration service SHALL support subscriptions to allow other systems to be informed when consents for a patient have changed." - this should be more precise, like "a consent administration service SHALL support subscriptions as defined by the FAST Subscription Topic, e.g. to allow other systems to be informed when consents for a patient have changed."
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-407" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-407detail" aria-expanded="false">407:&nbsp;Consent Administration Service SHALL support AuditEvent search</a></b>

<div class="collapse" id="req-407detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=systems%20SHALL%20support%20the%20searching%20for%20FAST%20Audit%20Events">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
</div>
</div>

<b><a id="requirement-266" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-266detail" aria-expanded="false">266:&nbsp;Consent Administration Service SHALL support AuditEvent search by FASTAuditEventConsent</a></b>

<div class="collapse" id="req-266detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=systems%20SHALL%20support%20the,consent">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Need to specify actor(s). For now, assuming CAS SHALL support and Consent Client MAY support
  * <b>Traced Test Cases:</b>
    * [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162)
    * [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163)
</div>
</div>

<b><a id="requirement-298" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-298detail" aria-expanded="false">298:&nbsp;Consent Administration Service SHALL support AuditEvent search by patient</a></b>

<div class="collapse" id="req-298detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=systems%20SHALL%20support%20the,patient">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Need to specify actor(s). For now, assuming CAS SHALL support and Consent Client MAY support
  * <b>Traced Test Cases:</b>
    * [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164)
    * [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165)
</div>
</div>

#### Requirements-technical-specification-client

<b><a id="requirement-67" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-67detail" aria-expanded="false">67:&nbsp;Consent Client SHALL query the consent administration service for the identifiers of the involved patients, practitioners, organizations, and related persons</a></b>

<div class="collapse" id="req-67detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=client%20systems%20SHALL%20query%20the%20consent%20administration%20service%20for%20the%20identifiers%20of%20the%20involved%20patients%2C%20practitioners%2C%20organizations%2C%20and%20related%20persons">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Not testable yet - need lots more details about the lifecycle of relates resource instances. 
Query or match?
Implies CAS is an MPI and similar for other resources?
Doesn’t say what triggers these queries to occur, or what effect it has on workflows, or whether discovered identifiers are used in resources...
  * <b>Traced Test Cases:</b>
</div>
</div>

<b><a id="requirement-202" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-202detail" aria-expanded="false">202:&nbsp;Consent Client MAY subscribe to Consent topics as defined by the FAST Subscription Topic</a></b>

<div class="collapse" id="req-202detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=To%20register%20a%20subscription%2C%20client%20systems%20will%20POST%20to%20a%20consent%20administration%20service%27s%20Subscription%20endpoint">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Notes:</b>&nbsp;- No conformance words "client will...", so not clear which actors SHALL or MAY support. For now, treating as MAY for both clients and servers - tests can be conditional.
- Nature of topic is it allows combinations of criteria. I'll call out each criterion below for traceability.
- TBD whether there need to be requirements for CAS to detect and fire Consent events or if implied by subs framework.
  * <b>Traced Test Cases:</b>
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-265" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-265detail" aria-expanded="false">265:&nbsp;This guide mandates that Subscriptions be used</a></b>

<div class="collapse" id="req-265detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=this%20guide%20mandates%20that%20Subscriptions%20be%20used">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Need conformance words - who does this apply to? Assuming clients, but which ones? What triggering actions? Are clients required to support only, or that they positively subscribe to specific other systems? Suggest referencing section with normative workflows.
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-167" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-167detail" aria-expanded="false">167:&nbsp;If a system accesses a Consent instance for determining whether information can be accessed, the Record Disclosure Operation SHALL be used</a></b>

<div class="collapse" id="req-167detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=The%20Record%20Disclosure%20Operation%20SHALL%20be%20used%20when%20a%20system%20accesses%20a%20Consent%20instance%20for%20determining%20whether%20informtion%20can%20be%20accessed">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;- Need to clarify which system has the responsibility for calling this - assuming Consent Client, calling the CAS.
- For now, assuming client calls after accessing.
  * <b>Traced Test Cases:</b>
    * [67: Workflow: Utilize Consent For Disclosure](rtm_test_cases.html#testcase-67)
</div>
</div>

<b><a id="requirement-267" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-267detail" aria-expanded="false">267:&nbsp;Consent Client SHALL support AuditEvent search by FASTAuditEventConsent</a></b>

<div class="collapse" id="req-267detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=systems%20SHALL%20support%20the,consent">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Implied - need requirement
  * <b>Traced Test Cases:</b>
    * [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162)
    * [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163)
</div>
</div>

<b><a id="requirement-299" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-299detail" aria-expanded="false">299:&nbsp;Consent Client SHALL support AuditEvent search by patient</a></b>

<div class="collapse" id="req-299detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html#:~:text=systems%20SHALL%20support%20the,patient">https://build.fhir.org/ig/HL7/fhir-consent-management/technical.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Implied - need requirement
  * <b>Traced Test Cases:</b>
    * [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164)
    * [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165)
</div>
</div>

#### Requirements-subscriptiontopic-fastconsentsubscriptiontopic-admin-service

<b><a id="requirement-600" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-600detail" aria-expanded="false">600:&nbsp;Consent Administration Service SHALL trigger a notification for every Consent create, unless filtered out</a></b>

<div class="collapse" id="req-600detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R5
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/subscriptiontopic.html#:~:text=Subscription%20Topics%20that%20include%20create,interaction%20is%20confirmed%20to%20apply.">https://hl7.org/fhir/subscriptiontopic.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Notes:</b>&nbsp;This requirement is derived by the definition in the topic plus the actual behavior defined in R5 SubscriptionTopic (which is what's linked).
  * <b>Traced Test Cases:</b>
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
</div>
</div>

<b><a id="requirement-606" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-606detail" aria-expanded="false">606:&nbsp;Consent Administration Service SHALL trigger a notification for every Consent update, unless filtered out</a></b>

<div class="collapse" id="req-606detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R5
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/subscriptiontopic.html#:~:text=Subscription%20Topics%20that%20include%20update,PUT%20with%20an%20identical%20resource).">https://hl7.org/fhir/subscriptiontopic.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Notes:</b>&nbsp;This requirement is derived by the definition in the topic plus the actual behavior defined in R5 SubscriptionTopic (which is what's linked).
  * <b>Traced Test Cases:</b>
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
</div>
</div>

<b><a id="requirement-607" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-607detail" aria-expanded="false">607:&nbsp;Consent Administration Service SHALL trigger a notification for every Consent delete, unless filtered out</a></b>

<div class="collapse" id="req-607detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FHIR R5
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/subscriptiontopic.html#:~:text=Subscription%20Topics%20that%20include%20delete,interaction%20is%20confirmed%20to%20apply.">https://hl7.org/fhir/subscriptiontopic.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Notes:</b>&nbsp;This requirement is derived by the definition in the topic plus the actual behavior defined in R5 SubscriptionTopic (which is what's linked).
  * <b>Traced Test Cases:</b>
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
</div>
</div>

<b><a id="requirement-603" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-603detail" aria-expanded="false">603:&nbsp;Consent Administration Service SHALL support Consent notification filter by SearchParameter FASTConsentPatientId</a></b>

<div class="collapse" id="req-603detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html#:~:text=%22canFilterBy%22%20%3A%20%5B%0A%20%20%20%20%7B%0A%20%20%20%20%20%20%22description%22%20%3A%20%22The%20identifier%20of%20the%20consent%20patient.%22%2C%0A%20%20%20%20%20%20%22filterParameter%22%20%3A%20%22patientId%22%2C%0A%20%20%20%20%20%20%22filterDefinition%22%20%3A%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/SearchParameter/fast%2Dconsent%2DpatientId%22%2C%0A%20%20%20%20%20%20%22comparator%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%22eq%22%0A%20%20%20%20%20%20%5D%0A%20%20%20%20%7D">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Related Requirement:</b>&nbsp;[476:&nbsp;SearchParameter FASTConsentPatientId](rtm_requirements.html#requirement-476)
  * <b>Traced Test Cases:</b>
    * [298: Workflow: Consent subscription and notification - FASTConsentPatientId](rtm_test_cases.html#testcase-298)
</div>
</div>

<b><a id="requirement-628" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-628detail" aria-expanded="false">628:&nbsp;Consent Administration Service SHALL support Consent notification filter by SearchParameter FASTConsentOrganizationId</a></b>

<div class="collapse" id="req-628detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html#:~:text=%7B%0A%20%20%20%20%20%20%22description%22%20%3A%20%22The%20identifier%20of%20the%20organization%20actor%20that%20gained%20consent.%22%2C%0A%20%20%20%20%20%20%22filterParameter%22%20%3A%20%22organizationId%22%2C%0A%20%20%20%20%20%20%22filterDefinition%22%20%3A%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/SearchParameter/fast%2Dconsent%2DorganizationId%22%2C%0A%20%20%20%20%20%20%22comparator%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%22eq%22%0A%20%20%20%20%20%20%5D%0A%20%20%20%20%7D%2C">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Related Requirement:</b>&nbsp;[475:&nbsp;SearchParameter FASTConsentOrganizationId](rtm_requirements.html#requirement-475)
  * <b>Traced Test Cases:</b>
    * [299: Workflow: Consent subscription and notification - FASTConsentOrganizationId](rtm_test_cases.html#testcase-299)
</div>
</div>

<b><a id="requirement-629" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-629detail" aria-expanded="false">629:&nbsp;Consent Administration Service SHALL support Consent notification filter by actor identifier</a></b>

<div class="collapse" id="req-629detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html#:~:text=%7B%0A%20%20%20%20%20%20%22description%22%20%3A%20%22The%20identifier%20of%20one,modifier%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%22identifier%22%0A%20%20%20%20%20%20%5D%0A%20%20%20%20%7D%2C">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Traced Test Cases:</b>
    * [300: Workflow: Consent subscription and notification - actor](rtm_test_cases.html#testcase-300)
</div>
</div>

<b><a id="requirement-630" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-630detail" aria-expanded="false">630:&nbsp;Consent Administration Service SHALL support Consent notification filter by status</a></b>

<div class="collapse" id="req-630detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html#:~:text=%7B%0A%20%20%20%20%20%20%22description%22%20%3A%20%22The%20status%20of%20a%20consent.%22%2C%0A%20%20%20%20%20%20%22filterParameter%22%20%3A%20%22status%22%2C%0A%20%20%20%20%20%20%22filterDefinition%22%20%3A%20%22http%3A//hl7.org/fhir/SearchParameter/Consent%2Dstatus%22%2C%0A%20%20%20%20%20%20%22comparator%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%22eq%22%0A%20%20%20%20%20%20%5D%0A%20%20%20%20%7D%2C">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Traced Test Cases:</b>
    * [301: Workflow: Consent subscription and notification - status](rtm_test_cases.html#testcase-301)
</div>
</div>

<b><a id="requirement-631" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-631detail" aria-expanded="false">631:&nbsp;Consent Administration Service SHALL support Consent notification filter by scope</a></b>

<div class="collapse" id="req-631detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html#:~:text=%7B%0A%20%20%20%20%20%20%22description%22%20%3A%20%22The%20scope%20of%20the%20consent.%22%2C%0A%20%20%20%20%20%20%22filterParameter%22%20%3A%20%22scope%22%2C%0A%20%20%20%20%20%20%22filterDefinition%22%20%3A%20%22http%3A//hl7.org/fhir/SearchParameter/Consent%2Dscope%22%2C%0A%20%20%20%20%20%20%22comparator%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%22eq%22%0A%20%20%20%20%20%20%5D%0A%20%20%20%20%7D">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Traced Test Cases:</b>
    * [302: Workflow: Consent subscription and notification - scope](rtm_test_cases.html#testcase-302)
</div>
</div>

<b><a id="requirement-632" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-632detail" aria-expanded="false">632:&nbsp;Consent Administration Service SHALL support Consent notification filter combinations</a></b>

<div class="collapse" id="req-632detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html#:~:text=%7B%0A%20%20%20%20%20%20%22description%22%20%3A%20%22The%20scope%20of%20the%20consent.%22%2C%0A%20%20%20%20%20%20%22filterParameter%22%20%3A%20%22scope%22%2C%0A%20%20%20%20%20%20%22filterDefinition%22%20%3A%20%22http%3A//hl7.org/fhir/SearchParameter/Consent%2Dscope%22%2C%0A%20%20%20%20%20%20%22comparator%22%20%3A%20%5B%0A%20%20%20%20%20%20%20%20%22eq%22%0A%20%20%20%20%20%20%5D%0A%20%20%20%20%7D">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Traced Test Cases:</b>
    * [304: Workflow: Consent subscription and notification - all filters](rtm_test_cases.html#testcase-304)
</div>
</div>

<b><a id="requirement-633" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-633detail" aria-expanded="false">633:&nbsp;Consent Administration Service MAY support Consent notification filters by search parameters not listed by FASTConsentSubscriptionTopic</a></b>

<div class="collapse" id="req-633detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/components.html#:~:text=A%20server%20MAY%20support,parameters%20for%20best%20interoperability.">https://hl7.org/fhir/uv/subscriptions-backport/components.html</a>
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Parent:</b>&nbsp;[SubscriptionTopic FASTConsentSubscriptionTopic](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser.html#requirement-596)
  * <b>Notes:</b>&nbsp;Not going to test just yet
  * <b>Traced Test Cases:</b>
</div>
</div>

#### Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client

<b><a id="requirement-635" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-635detail" aria-expanded="false">635:&nbsp;Consent Client MAY support Consent notification filter by SearchParameter FASTConsentPatientId</a></b>

<div class="collapse" id="req-635detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Traced Test Cases:</b>
    * [298: Workflow: Consent subscription and notification - FASTConsentPatientId](rtm_test_cases.html#testcase-298)
</div>
</div>

<b><a id="requirement-636" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-636detail" aria-expanded="false">636:&nbsp;Consent Client MAY support Consent notification filter by SearchParameter FASTConsentOrganizationId</a></b>

<div class="collapse" id="req-636detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Traced Test Cases:</b>
    * [299: Workflow: Consent subscription and notification - FASTConsentOrganizationId](rtm_test_cases.html#testcase-299)
</div>
</div>

<b><a id="requirement-637" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-637detail" aria-expanded="false">637:&nbsp;Consent Client MAY support Consent notification filter by actor identifier</a></b>

<div class="collapse" id="req-637detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Traced Test Cases:</b>
    * [300: Workflow: Consent subscription and notification - actor](rtm_test_cases.html#testcase-300)
</div>
</div>

<b><a id="requirement-638" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-638detail" aria-expanded="false">638:&nbsp;Consent Client MAY support Consent notification filter by status</a></b>

<div class="collapse" id="req-638detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Traced Test Cases:</b>
    * [301: Workflow: Consent subscription and notification - status](rtm_test_cases.html#testcase-301)
</div>
</div>

<b><a id="requirement-639" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-639detail" aria-expanded="false">639:&nbsp;Consent Client MAY support Consent notification filter by scope</a></b>

<div class="collapse" id="req-639detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Traced Test Cases:</b>
    * [302: Workflow: Consent subscription and notification - scope](rtm_test_cases.html#testcase-302)
</div>
</div>

<b><a id="requirement-640" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-640detail" aria-expanded="false">640:&nbsp;Consent Client MAY support Consent notification filter combinations</a></b>

<div class="collapse" id="req-640detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Traced Test Cases:</b>
    * [304: Workflow: Consent subscription and notification - all filters](rtm_test_cases.html#testcase-304)
</div>
</div>

#### Requirements-conformance-admin-service

<b><a id="requirement-496" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-496detail" aria-expanded="false">496:&nbsp;Consent Administration Service SHALL support Subscription read</a></b>

<div class="collapse" id="req-496detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=into%20this%20element.-,Conformance%20in%20FHIR%20R4,SHALL%20support%20the%20Subscription%20resource%20(read,-/write).">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
</div>
</div>

<b><a id="requirement-497" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-497detail" aria-expanded="false">497:&nbsp;Consent Administration Service SHALL support Subscription write</a></b>

<div class="collapse" id="req-497detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=into%20this%20element.-,Conformance%20in%20FHIR%20R4,SHALL%20support%20the%20Subscription%20resource%20(read/write,-).">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

<b><a id="requirement-498" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-498detail" aria-expanded="false">498:&nbsp;Consent Administration Service SHALL support $status operation against Subscription resource</a></b>

<div class="collapse" id="req-498detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=into%20this%20element.-,Conformance%20in%20FHIR%20R4,SHALL%20support%20the%20%24status%20operation%20on%20the%20Subscription%20resource,-.">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [266: Operation: Get Subscription Status](rtm_test_cases.html#testcase-266)
</div>
</div>

<b><a id="requirement-499" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-499detail" aria-expanded="false">499:&nbsp;Consent Administration Service SHOULD support Subscription topic discovery via the CapabilityStatement SubscriptionTopic Canonical extension</a></b>

<div class="collapse" id="req-499detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=into%20this%20element.-,Conformance%20in%20FHIR%20R4,SHOULD%20support%20topic%20discovery%20via%20the%20CapabilityStatement%20SubscriptionTopic%20Canonical%20extension,-SHALL%20support%20at">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-500" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-500detail" aria-expanded="false">500:&nbsp;Consent Administration Service SHALL support at least one Subscription channel type, and SHOULD include one from Subscriptions R5 Backport IG</a></b>

<div class="collapse" id="req-500detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=into%20this%20element.-,Conformance%20in%20FHIR%20R4,least%20one%20channel%20type%2C%20and%20SHOULD%20include%20one%20from%20this%20guide,-SHALL%20support%20at">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALLSHOULD
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-501" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-501detail" aria-expanded="false">501:&nbsp;Consent Administration Service SHALL support at least one Subscription Payload Type</a></b>

<div class="collapse" id="req-501detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=into%20this%20element.-,Conformance%20in%20FHIR%20R4,SHALL%20support%20at%20least%20one%20Payload%20Type,-Note%20that%20in">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-502" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-502detail" aria-expanded="false">502:&nbsp;Consent Administration Service SHALL conform to the BackportSubscriptionCapabilityStatementR4 CapabilityStatement</a></b>

<div class="collapse" id="req-502detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=FHIR%20Servers%20claiming%20conformance%20to%20this%20Implementation%20Guide%20must%20conform%20to%20the%20expectations%20described%20in%20the%20Capability%20Statement%20appropriate%20to%20the%20implemented%20FHIR%20version.%20For%20FHIR%20R4%20servers%2C%20this%20guide%20defines%20the%20R4%20Server%20CapabilityStatement">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Expect this means include the same declarations in addition to including it in some way
  * <b>Traced Test Cases:</b>
</div>
</div>

<b><a id="requirement-567" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-567detail" aria-expanded="false">567:&nbsp;Consent Administration Service SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide</a></b>

<div class="collapse" id="req-567detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=For%20FHIR%20R4,by%20this%20guide.">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;Not exactly sure how to test this
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-504" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-504detail" aria-expanded="false">504:&nbsp;Consent Administration Service SHOULD declare conformance with the BackportSubscriptionCapabilityStatementR4 using CapabilityStatement.instantiates</a></b>

<div class="collapse" id="req-504detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=SHOULD%20declare%20conformance%20with%20the%20Backport%20Subscription%20Server%20Capability%20Statement%20by%20including%20its%20official%20URL%20in%20the%20server%E2%80%99s%20CapabilityStatement.instantiates%20element%3A%20http%3A//hl7.org/fhir/uv/subscriptions%2Dbackport/CapabilityStatement/backport%2Dsubscription%2Dserver%2Dr4">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Traced Test Cases:</b>
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
</div>
</div>

<b><a id="requirement-513" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-513detail" aria-expanded="false">513:&nbsp;Consent Administration Service SHALL support Subscription resources that conform to BackportSubscription profile</a></b>

<div class="collapse" id="req-513detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=server%2Dr4.-,SHALL%20specify%20the%20full%20capability%20details%20from%20the%20CapabilityStatement%20it%20claims,element%3A%20http%3A//hl7.org/fhir/uv/subscriptions%2Dbackport/StructureDefinition/backport%2Dsubscription,-Must%2Dsupport">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [141: Read an AuditEvent](rtm_test_cases.html#testcase-141)
    * [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142)
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
    * [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-506" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-506detail" aria-expanded="false">506:&nbsp;Consent Administration Service SHALL be able to read values in the backport-channel-type extension</a></b>

<div class="collapse" id="req-506detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-channel-type-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-507" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-507detail" aria-expanded="false">507:&nbsp;Consent Administration Service SHALL reject the subscription request if a client requests an unsupported channel via the backport-channel-type extension</a></b>

<div class="collapse" id="req-507detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-channel-type-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [308: Error: Create a Subscription - rest-hook - unsupported backport-channel-type](rtm_test_cases.html#testcase-308)
</div>
</div>

<b><a id="requirement-529" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-529detail" aria-expanded="false">529:&nbsp;Consent Administration Service SHALL be able to read values in the backport-filter-criteria extension</a></b>

<div class="collapse" id="req-529detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-filter-criteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-530" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-530detail" aria-expanded="false">530:&nbsp;Consent Administration Service SHALL be able to apply filters as described by any Subscription Topics the server advertises support for</a></b>

<div class="collapse" id="req-530detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-filter-criteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-531" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-531detail" aria-expanded="false">531:&nbsp;Consent Administration Service SHALL reject the subscription request if any filters are unsupported</a></b>

<div class="collapse" id="req-531detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-filter-criteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Will test with a variety of query strings that are not supported per the server's CapStmt.
  * <b>Traced Test Cases:</b>
    * [309: Error: Create a Subscription - rest-hook - unsupported filter](rtm_test_cases.html#testcase-309)
</div>
</div>

<b><a id="requirement-533" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-533detail" aria-expanded="false">533:&nbsp;Consent Administration Service SHALL be able to read values in the backport-payload-content extension</a></b>

<div class="collapse" id="req-533detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-payload-content-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

<b><a id="requirement-534" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-534detail" aria-expanded="false">534:&nbsp;Consent Administration Service SHALL include information in notifications as described in this guide based on the value of the backport-payload-content extension</a></b>

<div class="collapse" id="req-534detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-payload-content-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

<b><a id="requirement-535" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-535detail" aria-expanded="false">535:&nbsp;Consent Administration Service SHALL reject the subscription request if a client asks for a content level the server does not intend to support (e.g., does not meet security requirements)</a></b>

<div class="collapse" id="req-535detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-payload-content-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;This cannot be fully tested for a given system unless we know its specific requirements, but we can hit it with each content level as an exploratory test.
  * <b>Traced Test Cases:</b>
    * [310: Error: Create a Subscription - rest-hook - unsupported content level](rtm_test_cases.html#testcase-310)
</div>
</div>

<b><a id="requirement-563" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-563detail" aria-expanded="false">563:&nbsp;Consent Administration Service SHALL be able to generate a valid and correct R4 Backported R5 SubscriptionStatus resource for each notification</a></b>

<div class="collapse" id="req-563detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#notification-entry-subscriptionstatus-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-538" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-538detail" aria-expanded="false">538:&nbsp;Consent Administration Service SHALL be able to read values in Subscription.criteria for subscription topics referenced by it</a></b>

<div class="collapse" id="req-538detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#subscriptioncriteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

<b><a id="requirement-539" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-539detail" aria-expanded="false">539:&nbsp;Consent Administration Service SHALL reject the subscription request if it does not support a requested topic or will not honor the subscription otherwise</a></b>

<div class="collapse" id="req-539detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#subscriptioncriteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [311: Error: Create a Subscription - rest-hook - unsupported topic](rtm_test_cases.html#testcase-311)
</div>
</div>

#### Requirements-conformance-client

<b><a id="requirement-566" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-566detail" aria-expanded="false">566:&nbsp;Consent Client SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide</a></b>

<div class="collapse" id="req-566detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#:~:text=For%20FHIR%20R4,by%20this%20guide.">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHOULD
  * <b>Notes:</b>&nbsp;Not exactly sure how to test this
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

<b><a id="requirement-516" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-516detail" aria-expanded="false">516:&nbsp;Consent Client MAY support the backport-channel-type extension</a></b>

<div class="collapse" id="req-516detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-channel-type-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;MAY
  * <b>Notes:</b>&nbsp;Not testing at this time
  * <b>Traced Test Cases:</b>
</div>
</div>

<b><a id="requirement-532" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-532detail" aria-expanded="false">532:&nbsp;Consent Client SHALL be able to write values in the backport-filter-criteria extension</a></b>

<div class="collapse" id="req-532detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-payload-content-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

<b><a id="requirement-536" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-536detail" aria-expanded="false">536:&nbsp;Consent Client SHALL be able to write values in the backport-payload-content extension</a></b>

<div class="collapse" id="req-536detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#backport-payload-content-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

<b><a id="requirement-564" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-564detail" aria-expanded="false">564:&nbsp;Consent Client SHALL be able to process a valid R4 Backported R5 SubscriptionStatus resource without errors</a></b>

<div class="collapse" id="req-564detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#notification-entry-subscriptionstatus-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
    * [266: Operation: Get Subscription Status](rtm_test_cases.html#testcase-266)
</div>
</div>

<b><a id="requirement-540" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-540detail" aria-expanded="false">540:&nbsp;Consent Client SHALL be able to write subscription topic URLs in Subscription.criteria</a></b>

<div class="collapse" id="req-540detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#subscriptioncriteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

#### Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser

<b><a id="requirement-596" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-596detail" aria-expanded="false">596:&nbsp;SubscriptionTopic FASTConsentSubscriptionTopic</a></b>

<div class="collapse" id="req-596detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;This topic is defined as an auto-backported R5 SubscriptionTopic (see note below), so this means the requirements for processing it are defined in the captured R5 requirements below. Note: its raw representation (https://build.fhir.org/ig/HL7/fhir-consent-management/SubscriptionTopic-FASTConsentSubscriptionTopic.json) is as a Basic resource.
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

#### Requirements-structure-definitions-client-admin-service

<b><a id="requirement-464" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-464detail" aria-expanded="false">464:&nbsp;StructureDefinition FileConsentParameters</a></b>

<div class="collapse" id="req-464detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FileConsentParameters.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FileConsentParameters.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-70" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-70detail" aria-expanded="false">70:&nbsp;The FileConsent operation "consent" input parameter SHALL be 1..1 and conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-70detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FileConsentParameters-definitions.html#Parameters.parameter:consent">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FileConsentParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition FileConsentParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-464)
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-430" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-430detail" aria-expanded="false">430:&nbsp;The FileConsent operation "document" input parameter SHALL be 1..1 and conform to either the us-core-questionnaireresponse or FASTDocumentReference profile</a></b>

<div class="collapse" id="req-430detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FileConsentParameters-definitions.html#Parameters.parameter:document">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FileConsentParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition FileConsentParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-464)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-469" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-469detail" aria-expanded="false">469:&nbsp;StructureDefinition RevokeConsentParameters</a></b>

<div class="collapse" id="req-469detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-441" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-441detail" aria-expanded="false">441:&nbsp;The RevokeConsent operation "consent" input parameter SHALL be 1..1 and conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-441detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters-definitions.html#Parameters.parameter:consent">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition RevokeConsentParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-469)
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-448" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-448detail" aria-expanded="false">448:&nbsp;The RevokeConsent operation "patient" input parameter SHALL be 1..1 and conform to the us-core-patient profile</a></b>

<div class="collapse" id="req-448detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters-definitions.html#Parameters.parameter:patient">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition RevokeConsentParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-469)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-443" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-443detail" aria-expanded="false">443:&nbsp;The RevokeConsent operation "document" input parameter SHALL be 0..1 and conform to either the us-core-questionnaireresponse or FASTDocumentReference profile</a></b>

<div class="collapse" id="req-443detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters-definitions.html#Parameters.parameter:document">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RevokeConsentParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition RevokeConsentParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-469)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-470" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-470detail" aria-expanded="false">470:&nbsp;StructureDefinition RecordDisclosureParameters</a></b>

<div class="collapse" id="req-470detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RecordDisclosureParameters.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RecordDisclosureParameters.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-452" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-452detail" aria-expanded="false">452:&nbsp;The RecordDisclosure operation "disclosure" input parameter SHALL be 1..1 and conform to the 	FASTConsentAuditEvent profile</a></b>

<div class="collapse" id="req-452detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RecordDisclosureParameters-definitions.html#key_Parameters.parameter:disclosure">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RecordDisclosureParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition RecordDisclosureParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-470)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-450" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-450detail" aria-expanded="false">450:&nbsp;The RecordDisclosure operation "consent" input parameter SHALL be 1..1 and conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-450detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RecordDisclosureParameters-definitions.html#Parameters.parameter:consent">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-RecordDisclosureParameters-definitions.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[StructureDefinition RecordDisclosureParameters](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-structure-definitions-client-admin-service.html#requirement-470)
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-477" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-477detail" aria-expanded="false">477:&nbsp;StructureDefinition FASTSubscription</a></b>

<div class="collapse" id="req-477detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTSubscription.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTSubscription.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Related Requirement:</b>&nbsp;[595:&nbsp;StructureDefinition BackportSubscription](rtm_requirements.html#requirement-595)
  * <b>Notes:</b>&nbsp;- No requirements to use this yet
- The constraint that status is always "active" might not make sense. I think the client is supposed to POST it as "requested".
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

<b><a id="requirement-595" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-595detail" aria-expanded="false">595:&nbsp;StructureDefinition BackportSubscription</a></b>

<div class="collapse" id="req-595detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition-backport-subscription.html">https://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition-backport-subscription.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

<b><a id="requirement-597" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-597detail" aria-expanded="false">597:&nbsp;StructureDefinition FASTConsent</a></b>

<div class="collapse" id="req-597detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTConsent.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTConsent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Many nested profiles, including from US Core. Will be checked by validator.
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

<b><a id="requirement-599" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-599detail" aria-expanded="false">599:&nbsp;StructureDefinition FASTDocumentReference</a></b>

<div class="collapse" id="req-599detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTDocumentReference.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTDocumentReference.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Many nested profiles, including from US Core. Will be checked by validator.
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

<b><a id="requirement-601" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-601detail" aria-expanded="false">601:&nbsp;StructureDefinition FASTReference</a></b>

<div class="collapse" id="req-601detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTReference.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTReference.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Many nested profiles, including from US Core. Will be checked by validator.
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

<b><a id="requirement-598" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-598detail" aria-expanded="false">598:&nbsp;StructureDefinition FASTConsentAuditEvent</a></b>

<div class="collapse" id="req-598detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTConsentAuditEvent.html">https://build.fhir.org/ig/HL7/fhir-consent-management/StructureDefinition-FASTConsentAuditEvent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Many nested profiles, including from US Core. Will be checked by validator.
  * <b>Traced Test Cases:</b>
    * [140: Validate FHIR resources](rtm_test_cases.html#testcase-140)
</div>
</div>

#### Requirements-conformance-client-admin-service

<b><a id="requirement-562" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-562detail" aria-expanded="false">562:&nbsp;Notification bundles SHALL contain a FHIR R4 Parameters resource, conforming to the R4 Backported R5 SubscriptionStatus profile, as the first entry</a></b>

<div class="collapse" id="req-562detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#notification-entry-subscriptionstatus-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;Not sure why, but this requirement is nearly repeated a couple sentences later as "The status entry SHALL be the first entry of each notification bundle." No need to capture that.
  * <b>Traced Test Cases:</b>
    * [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265)
</div>
</div>

<b><a id="requirement-537" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-537detail" aria-expanded="false">537:&nbsp;Subscription.criteria SHALL contain the canonical URL for the Subscription Topic</a></b>

<div class="collapse" id="req-537detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/conformance.html#subscriptioncriteria-1">https://hl7.org/fhir/uv/subscriptions-backport/conformance.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [199: Read a Subscription](rtm_test_cases.html#testcase-199)
    * [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232)
</div>
</div>

#### Requirements-workflow-client-admin-service

<b><a id="requirement-541" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-541detail" aria-expanded="false">541:&nbsp;Informative: Consent Client and Consent Administration Service generally follow the subscription workflow for R4 systems in section 2.3.3</a></b>

<div class="collapse" id="req-541detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;Subscriptions R5 Backport
  * <b>Link to Text:</b>&nbsp;<a href="https://hl7.org/fhir/uv/subscriptions-backport/workflow.html#workflow-fhir-r4">https://hl7.org/fhir/uv/subscriptions-backport/workflow.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Notes:</b>&nbsp;All constituent parts of this workflow are normatively defined elsewhere. Will use this workflow as a basis for the test cases needed.
  * <b>Traced Test Cases:</b>
    * [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100)
    * [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303)
</div>
</div>

#### Requirements-search-parameters-client-admin-service

<b><a id="requirement-472" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-472detail" aria-expanded="false">472:&nbsp;SearchParameter FASTConsentController</a></b>

<div class="collapse" id="req-472detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-controller.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-controller.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144)
    * [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145)
</div>
</div>

<b><a id="requirement-473" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-473detail" aria-expanded="false">473:&nbsp;SearchParameter FASTConsentGrantee</a></b>

<div class="collapse" id="req-473detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-grantee.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-grantee.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [148: Search for Consent by FASTConsentGrantee - JSON](rtm_test_cases.html#testcase-148)
    * [149: Search for Consent by FASTConsentGrantee - XML](rtm_test_cases.html#testcase-149)
</div>
</div>

<b><a id="requirement-474" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-474detail" aria-expanded="false">474:&nbsp;SearchParameter FASTConsentManager</a></b>

<div class="collapse" id="req-474detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-manager.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-manager.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150)
    * [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151)
</div>
</div>

<b><a id="requirement-475" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-475detail" aria-expanded="false">475:&nbsp;SearchParameter FASTConsentOrganizationId</a></b>

<div class="collapse" id="req-475detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-organizationId.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-organizationId.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [152: Search for Consent by FASTConsentOrganizationId - JSON](rtm_test_cases.html#testcase-152)
    * [153: Search for Consent by FASTConsentOrganizationId - XML](rtm_test_cases.html#testcase-153)
</div>
</div>

<b><a id="requirement-476" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-476detail" aria-expanded="false">476:&nbsp;SearchParameter FASTConsentPatientId</a></b>

<div class="collapse" id="req-476detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-patientId.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-consent-patientId.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [156: Search for Consent by FASTConsentPatientId - JSON](rtm_test_cases.html#testcase-156)
    * [157: Search for Consent by FASTConsentPatientId - XML](rtm_test_cases.html#testcase-157)
</div>
</div>

<b><a id="requirement-471" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-471detail" aria-expanded="false">471:&nbsp;SearchParameter FASTAuditEventConsent</a></b>

<div class="collapse" id="req-471detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-auditevent-consent.html">https://build.fhir.org/ig/HL7/fhir-consent-management/SearchParameter-fast-auditevent-consent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162)
    * [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163)
</div>
</div>

#### Requirements-extended-operations-client-admin-service

<b><a id="requirement-463" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-463detail" aria-expanded="false">463:&nbsp;OperationDefinition FileConsent</a></b>

<div class="collapse" id="req-463detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.html">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-133" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-133detail" aria-expanded="false">133:&nbsp;The FileConsent operation is invoked as [base]/Consent/$fileConsent</a></b>

<div class="collapse" id="req-133detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.html#:~:text=URL%3A%20%5Bbase%5D/Consent/%24fileConsent">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition FileConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-463)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-134" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-134detail" aria-expanded="false">134:&nbsp;The FileConsent operation input parameters SHALL conform to the FileConsentParameters profile</a></b>

<div class="collapse" id="req-134detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html#:~:text=%22inputProfile%22%20%3A%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/fileConsentParameters%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition FileConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-463)
  * <b>Notes:</b>&nbsp;For the most part, I'm not going to trace to everything in StructDefs, because the FHIR validator will check these. We may revisit this decision.
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-135" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-135detail" aria-expanded="false">135:&nbsp;The FileConsent operation "consent" input parameter SHALL be 1..1 and a Consent resource</a></b>

<div class="collapse" id="req-135detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html#:~:text=%22name%22%20%3A%20%22consent%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22in%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%201%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22The%20Consent%20instance%20to%20file%20(see%20Input%20Parameters%20Profile%20for%20conformance)%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22Consent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition FileConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-463)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-166" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-166detail" aria-expanded="false">166:&nbsp;The FileConsent operation "document" input parameter SHALL be 1..1 and any resource</a></b>

<div class="collapse" id="req-166detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html#:~:text=%22name%22%20%3A%20%22document%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22in%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%201%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22Accompanying%20documentation%20for%20the%20Consent%20in%20the%20form%20of%20a%20DocumentReference%20or%20QuestionnaireResponse%20(see%20Input%20Parameters%20Profile%20for%20conformance)%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22Resource%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition FileConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-463)
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-168" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-168detail" aria-expanded="false">168:&nbsp;The FileConsent operation "return" output parameter SHALL be 0..1 and be an OperationOutcome</a></b>

<div class="collapse" id="req-168detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html#:~:text=%22name%22%20%3A%20%22return%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22out%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%200%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22Optional%20outcome%20of%20the%20operation%20call%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22OperationOutcome%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-file-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition FileConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-463)
  * <b>Notes:</b>&nbsp;Note no defined way to return Consent ID
  * <b>Traced Test Cases:</b>
    * [68: Operation: File a Consent](rtm_test_cases.html#testcase-68)
</div>
</div>

<b><a id="requirement-466" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-466detail" aria-expanded="false">466:&nbsp;OperationDefinition RevokeConsent</a></b>

<div class="collapse" id="req-466detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.html">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-438" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-438detail" aria-expanded="false">438:&nbsp;The RevokeConsent operation is invoked as [base]/Consent/$revokeConsent</a></b>

<div class="collapse" id="req-438detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.html#:~:text=URL%3A%20%5Bbase%5D/Consent/%24revokeConsent">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RevokeConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-466)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-439" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-439detail" aria-expanded="false">439:&nbsp;The RevokeConsent operation input parameters SHALL conform to the RevokeConsentParameters profile</a></b>

<div class="collapse" id="req-439detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html#:~:text=%22inputProfile%22%20%3A%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/RevokeConsentParameters%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RevokeConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-466)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-440" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-440detail" aria-expanded="false">440:&nbsp;The RevokeConsent operation "consent" input parameter SHALL be 1..1 and conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-440detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html#:~:text=%22name%22%20%3A%20%22consent,us/consent%2Dmanagement/StructureDefinition/FASTConsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RevokeConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-466)
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-447" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-447detail" aria-expanded="false">447:&nbsp;The RevokeConsent operation "patient" input parameter SHALL be 1..1 and conform to the us-core-patient profile</a></b>

<div class="collapse" id="req-447detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html#:~:text=%22name%22%20%3A%20%22patient,core/StructureDefinition/us%2Dcore%2Dpatient%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RevokeConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-466)
  * <b>Notes:</b>&nbsp;- See http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html
- Consider tracking that
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-442" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-442detail" aria-expanded="false">442:&nbsp;The RevokeConsent operation "document" input parameter SHALL be 0..1 and any resource</a></b>

<div class="collapse" id="req-442detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html#:~:text=%22name%22%20%3A%20%22document%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22in%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%200%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22Accompanying%20documentation%20for%20the%20revocation%20of%20the%20Consent%20in%20the%20form%20of%20a%20DocumentReference%20or%20QuestionnaireResponse%20(see%20Input%20Parameters%20Profile%20for%20conformance)%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22Resource%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RevokeConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-466)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-444" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-444detail" aria-expanded="false">444:&nbsp;The RevokeConsent operation "return" output parameter SHALL be 0..1 and be an OperationOutcome</a></b>

<div class="collapse" id="req-444detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html#:~:text=%22name%22%20%3A%20%22return%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22out%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%200%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22Optional%20outcome%20of%20the%20operation%20call%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22OperationOutcome%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-revoke-consent.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RevokeConsent](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-466)
  * <b>Traced Test Cases:</b>
    * [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70)
</div>
</div>

<b><a id="requirement-467" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-467detail" aria-expanded="false">467:&nbsp;OperationDefinition RecordDisclosure</a></b>

<div class="collapse" id="req-467detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.html">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-445" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-445detail" aria-expanded="false">445:&nbsp;The RecordDisclosure operation is invoked as [base]/AuditEvent/$recordDisclosure</a></b>

<div class="collapse" id="req-445detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.html#:~:text=URL%3A%20%5Bbase%5D/AuditEvent/%24recordDisclosure">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RecordDisclosure](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-467)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-446" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-446detail" aria-expanded="false">446:&nbsp;The RecordDisclosure operation input parameters SHALL conform to the RecordDisclosureParameters profile</a></b>

<div class="collapse" id="req-446detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html#:~:text=%22inputProfile%22%20%3A%20%22http%3A//hl7.org/fhir/us/consent%2Dmanagement/StructureDefinition/RecordDisclosureParameters%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RecordDisclosure](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-467)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-451" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-451detail" aria-expanded="false">451:&nbsp;The RecordDisclosure operation "disclosure" input parameter SHALL be 1..1 and an AuditEvent resource</a></b>

<div class="collapse" id="req-451detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html#:~:text=%22name%22%20%3A%20%22disclosure%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22in%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%201%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22An%20AuditEvent%20detailing%20the%20disclosure%20(see%20Input%20Parameters%20Profile%20for%20conformance)%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22AuditEvent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RecordDisclosure](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-467)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-449" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-449detail" aria-expanded="false">449:&nbsp;The RecordDisclosure operation "consent" input parameter SHALL be 1..1 and conform to the FASTConsent profile</a></b>

<div class="collapse" id="req-449detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html#:~:text=%22name%22%20%3A%20%22consent,us/consent%2Dmanagement/StructureDefinition/FASTConsent%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Parent:</b>&nbsp;[OperationDefinition RecordDisclosure](https://build.fhir.org/ig/HL7/fhir-consent-management/Requirements-extended-operations-client-admin-service.html#requirement-467)
  * <b>Related Requirement:</b>&nbsp;[597:&nbsp;StructureDefinition FASTConsent](rtm_requirements.html#requirement-597)
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

<b><a id="requirement-453" title="Click to Open or Close Details" data-toggle="collapse" data-target="#req-453detail" aria-expanded="false">453:&nbsp;The RecordDisclosure operation "return" output parameter SHALL be 0..1 and be an OperationOutcome</a></b>

<div class="collapse" id="req-453detail">
<div class="card card-body" style="border:1px solid;border-color:#cccccc;padding:10px" markdown="1">
  * <b>Specification:</b>&nbsp;HL7 FAST Consent IG
  * <b>Link to Text:</b>&nbsp;<a href="https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html#:~:text=%22name%22%20%3A%20%22return%22%2C%0A%20%20%20%20%20%20%22use%22%20%3A%20%22out%22%2C%0A%20%20%20%20%20%20%22min%22%20%3A%200%2C%0A%20%20%20%20%20%20%22max%22%20%3A%20%221%22%2C%0A%20%20%20%20%20%20%22documentation%22%20%3A%20%22Optional%20outcome%20of%20the%20operation%20call%22%2C%0A%20%20%20%20%20%20%22type%22%20%3A%20%22OperationOutcome%22">https://build.fhir.org/ig/HL7/fhir-consent-management/OperationDefinition-record-disclosure.json.html</a>
  * <b>Conformance:</b>&nbsp;SHALL
  * <b>Traced Test Cases:</b>
    * [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69)
</div>
</div>

