
### RTM - Coverage (Requirements)

<p>This page displays the Requirements Traceability Matrix (RTM) showing the coverage of the requirements to test cases. All requirements captured are included, whether or not they are traced. Each Requirements header may be expanded to show the requirements coverage details to the traced test cases.</p>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#components-admin-service-detail" aria-expanded="false">Requirements-components-admin-service</a></b>

<div class="collapse" id="components-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="565: Consent Administration Service SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide" href="rtm_requirements.html#requirement-565">requirement-565</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#components-client-detail" aria-expanded="false">Requirements-components-client</a></b>

<div class="collapse" id="components-client-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="512: Consent Client SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide" href="rtm_requirements.html#requirement-512">requirement-512</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b><span style="background-color: lightyellow">97.87%</span>&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#capstmt-admin-service-detail" aria-expanded="false">Requirements-capstmt-admin-service</a></b>

<div class="collapse" id="capstmt-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="1: Consent Administration Service SHALL implement the server CapabilityStatement" href="rtm_requirements.html#requirement-1">requirement-1</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="2: Consent Administration Service SHALL support JSON FHIR" href="rtm_requirements.html#requirement-2">requirement-2</a> | [136: Obtain server CapabilityStatement - JSON](rtm_test_cases.html#testcase-136) |
| <a title="34: Consent Administration Service SHALL support XML FHIR" href="rtm_requirements.html#requirement-34">requirement-34</a> | [137: Obtain server CapabilityStatement - XML](rtm_test_cases.html#testcase-137) |
| <a title="43: Consent Administration Service SHALL support Consent resource" href="rtm_requirements.html#requirement-43">requirement-43</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="35: Consent Administration Service SHALL support Consent resources that conform to FASTConsent profile" href="rtm_requirements.html#requirement-35">requirement-35</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
|  | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="331: Consent Administration Service SHALL mark with profile assertions Consent resources that conform to the FASTConsent profile" href="rtm_requirements.html#requirement-331">requirement-331</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [166: Search for Consent by FASTConsent profile - JSON](rtm_test_cases.html#testcase-166) |
|  | [167: Search for Consent by FASTConsent profile - XML](rtm_test_cases.html#testcase-167) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [67: Workflow: Utilize Consent For Disclosure](rtm_test_cases.html#testcase-67) |
| <a title="332: Consent Administration Service SHALL support searching by the _profile parameter for Consent resources that conform to the FASTConsent profile" href="rtm_requirements.html#requirement-332">requirement-332</a> | [166: Search for Consent by FASTConsent profile - JSON](rtm_test_cases.html#testcase-166) |
|  | [167: Search for Consent by FASTConsent profile - XML](rtm_test_cases.html#testcase-167) |
| <a title="36: Consent Administration Service SHALL support Consent read" href="rtm_requirements.html#requirement-36">requirement-36</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="37: Consent Administration Service SHALL support Consent search" href="rtm_requirements.html#requirement-37">requirement-37</a> | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="199: Consent Administration Service SHALL support Consent search by FASTConsentController" href="rtm_requirements.html#requirement-199">requirement-199</a> | [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144) |
|  | [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="72: Consent Administration Service SHALL support Consent search by date" href="rtm_requirements.html#requirement-72">requirement-72</a> | [146: Search for Consent by date - JSON](rtm_test_cases.html#testcase-146) |
|  | [147: Search for Consent by date - XML](rtm_test_cases.html#testcase-147) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="38: Consent Administration Service SHALL support Consent search by FASTConsentGrantee" href="rtm_requirements.html#requirement-38">requirement-38</a> | [148: Search for Consent by FASTConsentGrantee - JSON](rtm_test_cases.html#testcase-148) |
|  | [149: Search for Consent by FASTConsentGrantee - XML](rtm_test_cases.html#testcase-149) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="200: Consent Administration Service SHALL support Consent search by FASTConsentManager" href="rtm_requirements.html#requirement-200">requirement-200</a> | [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150) |
|  | [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="39: Consent Administration Service SHALL support Consent search by FASTConsentOrganizationId" href="rtm_requirements.html#requirement-39">requirement-39</a> | [152: Search for Consent by FASTConsentOrganizationId - JSON](rtm_test_cases.html#testcase-152) |
|  | [153: Search for Consent by FASTConsentOrganizationId - XML](rtm_test_cases.html#testcase-153) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="40: Consent Administration Service SHALL support Consent search by patient" href="rtm_requirements.html#requirement-40">requirement-40</a> | [154: Search for Consent by patient - JSON](rtm_test_cases.html#testcase-154) |
|  | [155: Search for Consent by patient - XML](rtm_test_cases.html#testcase-155) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="368: Consent Administration Service SHALL support Consent search by FASTConsentPatientId" href="rtm_requirements.html#requirement-368">requirement-368</a> | [156: Search for Consent by FASTConsentPatientId - JSON](rtm_test_cases.html#testcase-156) |
|  | [157: Search for Consent by FASTConsentPatientId - XML](rtm_test_cases.html#testcase-157) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="42: Consent Administration Service SHALL support Consent search by scope" href="rtm_requirements.html#requirement-42">requirement-42</a> | [158: Search for Consent by scope - JSON](rtm_test_cases.html#testcase-158) |
|  | [159: Search for Consent by scope - XML](rtm_test_cases.html#testcase-159) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="41: Consent Administration Service SHALL support Consent search by status" href="rtm_requirements.html#requirement-41">requirement-41</a> | [160: Search for Consent by status - JSON](rtm_test_cases.html#testcase-160) |
|  | [161: Search for Consent by status - XML](rtm_test_cases.html#testcase-161) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="46: Consent Administration Service SHALL support $fileConsent operation against Consent resource" href="rtm_requirements.html#requirement-46">requirement-46</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="374: Consent Administration Service SHALL support $revokeConsent operation against Consent resource" href="rtm_requirements.html#requirement-374">requirement-374</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="661: Consent Administration Service SHALL support Subscription resource" href="rtm_requirements.html#requirement-661">requirement-661</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
| <a title="377: Consent Administration Service SHALL support Consent subscriptions as defined by the FASTConsentSubscriptionTopic for FHIR R4 with Subscriptions Backport" href="rtm_requirements.html#requirement-377">requirement-377</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="378: Consent Administration Service SHALL support Subscription create" href="rtm_requirements.html#requirement-378">requirement-378</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="379: Consent Administration Service SHALL support Subscription update" href="rtm_requirements.html#requirement-379">requirement-379</a> | [306: Workflow: Update a Subscription - rest-hook](rtm_test_cases.html#testcase-306) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="380: Consent Administration Service SHALL support Subscription delete" href="rtm_requirements.html#requirement-380">requirement-380</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="415: Consent Administration Service SHALL support $recordDisclosure operation against AuditEvent resource" href="rtm_requirements.html#requirement-415">requirement-415</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="397: Consent Administration Service SHALL support AuditEvent resource" href="rtm_requirements.html#requirement-397">requirement-397</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="398: Consent Administration Service SHALL support AuditEvent resources that conform to FASTConsentAuditEvent profile" href="rtm_requirements.html#requirement-398">requirement-398</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="399: Consent Administration Service SHALL mark with profile assertions AuditEvent resources that conform to the FASTConsentAuditEvent profile" href="rtm_requirements.html#requirement-399">requirement-399</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168) |
|  | [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169) |
| <a title="400: Consent Administration Service SHALL support searching by the _profile parameter for AuditEvent resources that conform to the FASTConsentAuditEvent profile" href="rtm_requirements.html#requirement-400">requirement-400</a> | [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168) |
|  | [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169) |
| <a title="404: Consent Administration Service SHALL support AuditEvent read" href="rtm_requirements.html#requirement-404">requirement-404</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="406: Consent Administration Service SHALL support AuditEvent search" href="rtm_requirements.html#requirement-406">requirement-406</a> | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="409: Consent Administration Service SHALL support AuditEvent search by FASTAuditEventConsent" href="rtm_requirements.html#requirement-409">requirement-409</a> | [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162) |
|  | [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="412: Consent Administration Service SHALL support AuditEvent search by patient" href="rtm_requirements.html#requirement-412">requirement-412</a> | [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164) |
|  | [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="505: Consent Administration Service SHALL support Subscription read" href="rtm_requirements.html#requirement-505">requirement-505</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
| <a title="503: Consent Administration Service SHOULD support Subscription write via POST or PUT" href="rtm_requirements.html#requirement-503">requirement-503</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [305: Workflow: Create a Subscription - rest-hook PUT](rtm_test_cases.html#testcase-305) |
| <a title="509: Consent Administration Service SHOULD support Subscription update via PUT or PATCH" href="rtm_requirements.html#requirement-509">requirement-509</a> | [306: Workflow: Update a Subscription - rest-hook](rtm_test_cases.html#testcase-306) |
|  | [307: Workflow: Update a Subscription - rest-hook PATCH](rtm_test_cases.html#testcase-307) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="510: Consent Administration Service SHOULD support Subscription delete" href="rtm_requirements.html#requirement-510">requirement-510</a> | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="511: Consent Administration Service SHOULD support Subscription search" href="rtm_requirements.html#requirement-511">requirement-511</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="602: Consent Administration Service SHALL support Subscription search by url" href="rtm_requirements.html#requirement-602">requirement-602</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="604: Consent Administration Service SHOULD support Subscription search by status" href="rtm_requirements.html#requirement-604">requirement-604</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="508: Consent Administration Service SHALL support $status operation against Subscription resource" href="rtm_requirements.html#requirement-508">requirement-508</a> | [266: Operation: Get Subscription Status](rtm_test_cases.html#testcase-266) |
| <a title="694: Consent Administration Service MAY support $events operation against Subscription resource" href="rtm_requirements.html#requirement-694">requirement-694</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="695: Consent Administration Service MAY support $get-ws-binding-token operation against Subscription resource" href="rtm_requirements.html#requirement-695">requirement-695</a> | n/a |
| <a title="517: Consent Administration Service SHALL support Subscription resources that conform to BackportSubscription profile" href="rtm_requirements.html#requirement-517">requirement-517</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="514: Consent Administration Service SHALL mark with profile assertions Subscription resources that conform to the BackportSubscription profile" href="rtm_requirements.html#requirement-514">requirement-514</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168) |
|  | [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169) |
|  | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="515: Consent Administration Service SHALL support searching by the _profile parameter for Subscription resources that conform to the BackportSubscription profile" href="rtm_requirements.html#requirement-515">requirement-515</a> | [168: Search for AuditEvent by FASTConsentAuditEvent profile - JSON](rtm_test_cases.html#testcase-168) |
|  | [169: Search for AuditEvent by FASTConsentAuditEvent profile - XML](rtm_test_cases.html#testcase-169) |
| **Coverage** | **97.87%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#capstmt-client-detail" aria-expanded="false">Requirements-capstmt-client</a></b>

<div class="collapse" id="capstmt-client-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="48: Consent Client SHALL implement the client CapabilityStatement" href="rtm_requirements.html#requirement-48">requirement-48</a> | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="49: Consent Client SHALL support JSON FHIR" href="rtm_requirements.html#requirement-49">requirement-49</a> | [136: Obtain server CapabilityStatement - JSON](rtm_test_cases.html#testcase-136) |
|  | [138: Test client CapabilityStatement - JSON](rtm_test_cases.html#testcase-138) |
| <a title="50: Consent Client SHALL support XML FHIR" href="rtm_requirements.html#requirement-50">requirement-50</a> | [137: Obtain server CapabilityStatement - XML](rtm_test_cases.html#testcase-137) |
|  | [139: Test client CapabilityStatement - XML](rtm_test_cases.html#testcase-139) |
| <a title="333: Consent Client SHALL support Consent resource" href="rtm_requirements.html#requirement-333">requirement-333</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="52: Consent Client SHALL support Consent resources that conform to FASTConsent profile" href="rtm_requirements.html#requirement-52">requirement-52</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
|  | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
|  | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="334: Consent Client SHALL mark with profile assertions Consent resources that conform to the FASTConsent profile" href="rtm_requirements.html#requirement-334">requirement-334</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
|  | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
|  | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="56: Consent Client SHALL support Consent read" href="rtm_requirements.html#requirement-56">requirement-56</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="57: Consent Client SHALL support Consent search" href="rtm_requirements.html#requirement-57">requirement-57</a> | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="58: Consent Client SHALL support Consent search by FASTConsentController" href="rtm_requirements.html#requirement-58">requirement-58</a> | [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144) |
|  | [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="369: Consent Client SHALL support Consent search by date" href="rtm_requirements.html#requirement-369">requirement-369</a> | [146: Search for Consent by date - JSON](rtm_test_cases.html#testcase-146) |
|  | [147: Search for Consent by date - XML](rtm_test_cases.html#testcase-147) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="370: Consent Client SHALL support Consent search by FASTConsentGrantee" href="rtm_requirements.html#requirement-370">requirement-370</a> | [148: Search for Consent by FASTConsentGrantee - JSON](rtm_test_cases.html#testcase-148) |
|  | [149: Search for Consent by FASTConsentGrantee - XML](rtm_test_cases.html#testcase-149) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="371: Consent Client SHALL support Consent search by FASTConsentManager" href="rtm_requirements.html#requirement-371">requirement-371</a> | [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150) |
|  | [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="59: Consent Client SHALL support Consent search by FASTConsentOrganizationId" href="rtm_requirements.html#requirement-59">requirement-59</a> | [152: Search for Consent by FASTConsentOrganizationId - JSON](rtm_test_cases.html#testcase-152) |
|  | [153: Search for Consent by FASTConsentOrganizationId - XML](rtm_test_cases.html#testcase-153) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="60: Consent Client SHALL support Consent search by patient" href="rtm_requirements.html#requirement-60">requirement-60</a> | [154: Search for Consent by patient - JSON](rtm_test_cases.html#testcase-154) |
|  | [155: Search for Consent by patient - XML](rtm_test_cases.html#testcase-155) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="372: Consent Client SHALL support Consent search by FASTConsentPatientId" href="rtm_requirements.html#requirement-372">requirement-372</a> | [156: Search for Consent by FASTConsentPatientId - JSON](rtm_test_cases.html#testcase-156) |
|  | [157: Search for Consent by FASTConsentPatientId - XML](rtm_test_cases.html#testcase-157) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="47: Consent Client SHALL support Consent search by scope" href="rtm_requirements.html#requirement-47">requirement-47</a> | [158: Search for Consent by scope - JSON](rtm_test_cases.html#testcase-158) |
|  | [159: Search for Consent by scope - XML](rtm_test_cases.html#testcase-159) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="61: Consent Client SHALL support Consent search by status" href="rtm_requirements.html#requirement-61">requirement-61</a> | [160: Search for Consent by status - JSON](rtm_test_cases.html#testcase-160) |
|  | [161: Search for Consent by status - XML](rtm_test_cases.html#testcase-161) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="53: Consent Client SHALL support $fileConsent operation against Consent resource" href="rtm_requirements.html#requirement-53">requirement-53</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="376: Consent Client SHALL support $revokeConsent operation against Consent resource" href="rtm_requirements.html#requirement-376">requirement-376</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="381: Consent Client SHALL support Consent subscriptions as defined by the FASTConsentSubscriptionTopic for FHIR R4 with Subscriptions Backport" href="rtm_requirements.html#requirement-381">requirement-381</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="382: Consent Client SHALL support Subscription create" href="rtm_requirements.html#requirement-382">requirement-382</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="383: Consent Client SHALL support Subscription update" href="rtm_requirements.html#requirement-383">requirement-383</a> | [306: Workflow: Update a Subscription - rest-hook](rtm_test_cases.html#testcase-306) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="384: Consent Client SHALL support Subscription delete" href="rtm_requirements.html#requirement-384">requirement-384</a> | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="416: Consent Client SHALL support $recordDisclosure operation against AuditEvent resource" href="rtm_requirements.html#requirement-416">requirement-416</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="401: Consent Client SHALL support AuditEvent resource" href="rtm_requirements.html#requirement-401">requirement-401</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="402: Consent Client SHALL support AuditEvent resources that conform to FASTConsentAuditEvent profile" href="rtm_requirements.html#requirement-402">requirement-402</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="403: Consent Client SHALL mark with profile assertions AuditEvent resources that conform to the FASTConsentAuditEvent profile" href="rtm_requirements.html#requirement-403">requirement-403</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="405: Consent Client SHALL support AuditEvent read" href="rtm_requirements.html#requirement-405">requirement-405</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="408: Consent Client SHALL support AuditEvent search" href="rtm_requirements.html#requirement-408">requirement-408</a> | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="411: Consent Client SHALL support AuditEvent search by FASTAuditEventConsent" href="rtm_requirements.html#requirement-411">requirement-411</a> | [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162) |
|  | [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| <a title="414: Consent Client SHALL support AuditEvent search by patient" href="rtm_requirements.html#requirement-414">requirement-414</a> | [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164) |
|  | [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165) |
|  | [134: Test client CapabilityStatement](rtm_test_cases.html#testcase-134) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#technical-specification-admin-service-detail" aria-expanded="false">Requirements-technical-specification-admin-service</a></b>

<div class="collapse" id="technical-specification-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="68: Consent Administration Service SHOULD return OperationOutcome with details of which business rules did not allow an operation to be successful if an HTTP status code of 4xx or 5xx is returned" href="rtm_requirements.html#requirement-68">requirement-68</a> | [308: Error: Create a Subscription - rest-hook - unsupported backport-channel-type](rtm_test_cases.html#testcase-308) |
|  | [309: Error: Create a Subscription - rest-hook - unsupported filter](rtm_test_cases.html#testcase-309) |
| <a title="69: Consent Administration Service MAY return OperationOutcome for a successful operation" href="rtm_requirements.html#requirement-69">requirement-69</a> | [1: Read a Consent](rtm_test_cases.html#testcase-1) |
|  | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
|  | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
|  | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
|  | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="63: Consent Administration Service SHALL support Consent search" href="rtm_requirements.html#requirement-63">requirement-63</a> | [2: Search for a Consent](rtm_test_cases.html#testcase-2) |
| <a title="364: Consent Administration Service SHALL support Consent search by FASTConsentController" href="rtm_requirements.html#requirement-364">requirement-364</a> | [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144) |
|  | [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145) |
| <a title="365: Consent Administration Service SHALL support Consent search by date" href="rtm_requirements.html#requirement-365">requirement-365</a> | [146: Search for Consent by date - JSON](rtm_test_cases.html#testcase-146) |
|  | [147: Search for Consent by date - XML](rtm_test_cases.html#testcase-147) |
| <a title="367: Consent Administration Service SHALL support Consent search by FASTConsentManager" href="rtm_requirements.html#requirement-367">requirement-367</a> | [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150) |
|  | [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151) |
| <a title="71: Consent Administration Service SHALL support Consent search by patient" href="rtm_requirements.html#requirement-71">requirement-71</a> | [154: Search for Consent by patient - JSON](rtm_test_cases.html#testcase-154) |
|  | [155: Search for Consent by patient - XML](rtm_test_cases.html#testcase-155) |
| <a title="201: Consent Administration Service SHALL support Consent search by scope" href="rtm_requirements.html#requirement-201">requirement-201</a> | [158: Search for Consent by scope - JSON](rtm_test_cases.html#testcase-158) |
|  | [159: Search for Consent by scope - XML](rtm_test_cases.html#testcase-159) |
| <a title="73: Consent Administration Service SHALL support Consent search by status" href="rtm_requirements.html#requirement-73">requirement-73</a> | [160: Search for Consent by status - JSON](rtm_test_cases.html#testcase-160) |
|  | [161: Search for Consent by status - XML](rtm_test_cases.html#testcase-161) |
| <a title="62: Consent Administration Service SHALL support File Consent operation" href="rtm_requirements.html#requirement-62">requirement-62</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="101: Consent Administration Service SHALL support Revoke Consent operation" href="rtm_requirements.html#requirement-101">requirement-101</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="64: Consent Administration Service SHALL support Consent subscriptions (as defined by the FAST Subscription Topic for FHIR R4 with Subscriptions Backport)" href="rtm_requirements.html#requirement-64">requirement-64</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="407: Consent Administration Service SHALL support AuditEvent search" href="rtm_requirements.html#requirement-407">requirement-407</a> | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
| <a title="266: Consent Administration Service SHALL support AuditEvent search by FASTAuditEventConsent" href="rtm_requirements.html#requirement-266">requirement-266</a> | [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162) |
|  | [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163) |
| <a title="298: Consent Administration Service SHALL support AuditEvent search by patient" href="rtm_requirements.html#requirement-298">requirement-298</a> | [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164) |
|  | [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b><span style="background-color: lightyellow">83.33%</span>&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#technical-specification-client-detail" aria-expanded="false">Requirements-technical-specification-client</a></b>

<div class="collapse" id="technical-specification-client-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="67: Consent Client SHALL query the consent administration service for the identifiers of the involved patients, practitioners, organizations, and related persons" href="rtm_requirements.html#requirement-67">requirement-67</a> | n/a |
| <a title="202: Consent Client MAY subscribe to Consent topics as defined by the FAST Subscription Topic" href="rtm_requirements.html#requirement-202">requirement-202</a> | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="265: This guide mandates that Subscriptions be used" href="rtm_requirements.html#requirement-265">requirement-265</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="167: If a system accesses a Consent instance for determining whether information can be accessed, the Record Disclosure Operation SHALL be used" href="rtm_requirements.html#requirement-167">requirement-167</a> | [67: Workflow: Utilize Consent For Disclosure](rtm_test_cases.html#testcase-67) |
| <a title="267: Consent Client SHALL support AuditEvent search by FASTAuditEventConsent" href="rtm_requirements.html#requirement-267">requirement-267</a> | [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162) |
|  | [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163) |
| <a title="299: Consent Client SHALL support AuditEvent search by patient" href="rtm_requirements.html#requirement-299">requirement-299</a> | [164: Search for AuditEvent by patient - JSON](rtm_test_cases.html#testcase-164) |
|  | [165: Search for AuditEvent by patient - XML](rtm_test_cases.html#testcase-165) |
| **Coverage** | **83.33%** |
{: .grid }

</div>
</div>

<b><span style="background-color: lightyellow">90.00%</span>&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#subscriptiontopic-fastconsentsubscriptiontopic-admin-service-detail" aria-expanded="false">Requirements-subscriptiontopic-fastconsentsubscriptiontopic-admin-service</a></b>

<div class="collapse" id="subscriptiontopic-fastconsentsubscriptiontopic-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="600: Consent Administration Service SHALL trigger a notification for every Consent create, unless filtered out" href="rtm_requirements.html#requirement-600">requirement-600</a> | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
| <a title="606: Consent Administration Service SHALL trigger a notification for every Consent update, unless filtered out" href="rtm_requirements.html#requirement-606">requirement-606</a> | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
| <a title="607: Consent Administration Service SHALL trigger a notification for every Consent delete, unless filtered out" href="rtm_requirements.html#requirement-607">requirement-607</a> | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
| <a title="603: Consent Administration Service SHALL support Consent notification filter by SearchParameter FASTConsentPatientId" href="rtm_requirements.html#requirement-603">requirement-603</a> | [298: Workflow: Consent subscription and notification - FASTConsentPatientId](rtm_test_cases.html#testcase-298) |
| <a title="628: Consent Administration Service SHALL support Consent notification filter by SearchParameter FASTConsentOrganizationId" href="rtm_requirements.html#requirement-628">requirement-628</a> | [299: Workflow: Consent subscription and notification - FASTConsentOrganizationId](rtm_test_cases.html#testcase-299) |
| <a title="629: Consent Administration Service SHALL support Consent notification filter by actor identifier" href="rtm_requirements.html#requirement-629">requirement-629</a> | [300: Workflow: Consent subscription and notification - actor](rtm_test_cases.html#testcase-300) |
| <a title="630: Consent Administration Service SHALL support Consent notification filter by status" href="rtm_requirements.html#requirement-630">requirement-630</a> | [301: Workflow: Consent subscription and notification - status](rtm_test_cases.html#testcase-301) |
| <a title="631: Consent Administration Service SHALL support Consent notification filter by scope" href="rtm_requirements.html#requirement-631">requirement-631</a> | [302: Workflow: Consent subscription and notification - scope](rtm_test_cases.html#testcase-302) |
| <a title="632: Consent Administration Service SHALL support Consent notification filter combinations" href="rtm_requirements.html#requirement-632">requirement-632</a> | [304: Workflow: Consent subscription and notification - all filters](rtm_test_cases.html#testcase-304) |
| <a title="633: Consent Administration Service MAY support Consent notification filters by search parameters not listed by FASTConsentSubscriptionTopic" href="rtm_requirements.html#requirement-633">requirement-633</a> | n/a |
| **Coverage** | **90.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#subscriptiontopic-fastconsentsubscriptiontopic-client-detail" aria-expanded="false">Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client</a></b>

<div class="collapse" id="subscriptiontopic-fastconsentsubscriptiontopic-client-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="635: Consent Client MAY support Consent notification filter by SearchParameter FASTConsentPatientId" href="rtm_requirements.html#requirement-635">requirement-635</a> | [298: Workflow: Consent subscription and notification - FASTConsentPatientId](rtm_test_cases.html#testcase-298) |
| <a title="636: Consent Client MAY support Consent notification filter by SearchParameter FASTConsentOrganizationId" href="rtm_requirements.html#requirement-636">requirement-636</a> | [299: Workflow: Consent subscription and notification - FASTConsentOrganizationId](rtm_test_cases.html#testcase-299) |
| <a title="637: Consent Client MAY support Consent notification filter by actor identifier" href="rtm_requirements.html#requirement-637">requirement-637</a> | [300: Workflow: Consent subscription and notification - actor](rtm_test_cases.html#testcase-300) |
| <a title="638: Consent Client MAY support Consent notification filter by status" href="rtm_requirements.html#requirement-638">requirement-638</a> | [301: Workflow: Consent subscription and notification - status](rtm_test_cases.html#testcase-301) |
| <a title="639: Consent Client MAY support Consent notification filter by scope" href="rtm_requirements.html#requirement-639">requirement-639</a> | [302: Workflow: Consent subscription and notification - scope](rtm_test_cases.html#testcase-302) |
| <a title="640: Consent Client MAY support Consent notification filter combinations" href="rtm_requirements.html#requirement-640">requirement-640</a> | [304: Workflow: Consent subscription and notification - all filters](rtm_test_cases.html#testcase-304) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b><span style="background-color: lightyellow">95.24%</span>&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#conformance-admin-service-detail" aria-expanded="false">Requirements-conformance-admin-service</a></b>

<div class="collapse" id="conformance-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="496: Consent Administration Service SHALL support Subscription read" href="rtm_requirements.html#requirement-496">requirement-496</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
| <a title="497: Consent Administration Service SHALL support Subscription write" href="rtm_requirements.html#requirement-497">requirement-497</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| <a title="498: Consent Administration Service SHALL support $status operation against Subscription resource" href="rtm_requirements.html#requirement-498">requirement-498</a> | [266: Operation: Get Subscription Status](rtm_test_cases.html#testcase-266) |
| <a title="499: Consent Administration Service SHOULD support Subscription topic discovery via the CapabilityStatement SubscriptionTopic Canonical extension" href="rtm_requirements.html#requirement-499">requirement-499</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="500: Consent Administration Service SHALL support at least one Subscription channel type, and SHOULD include one from Subscriptions R5 Backport IG" href="rtm_requirements.html#requirement-500">requirement-500</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="501: Consent Administration Service SHALL support at least one Subscription Payload Type" href="rtm_requirements.html#requirement-501">requirement-501</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="502: Consent Administration Service SHALL conform to the BackportSubscriptionCapabilityStatementR4 CapabilityStatement" href="rtm_requirements.html#requirement-502">requirement-502</a> | n/a |
| <a title="567: Consent Administration Service SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide" href="rtm_requirements.html#requirement-567">requirement-567</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="504: Consent Administration Service SHOULD declare conformance with the BackportSubscriptionCapabilityStatementR4 using CapabilityStatement.instantiates" href="rtm_requirements.html#requirement-504">requirement-504</a> | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
| <a title="513: Consent Administration Service SHALL support Subscription resources that conform to BackportSubscription profile" href="rtm_requirements.html#requirement-513">requirement-513</a> | [141: Read an AuditEvent](rtm_test_cases.html#testcase-141) |
|  | [142: Search for an AuditEvent](rtm_test_cases.html#testcase-142) |
|  | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
|  | [101: Obtain server CapabilityStatement](rtm_test_cases.html#testcase-101) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="506: Consent Administration Service SHALL be able to read values in the backport-channel-type extension" href="rtm_requirements.html#requirement-506">requirement-506</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="507: Consent Administration Service SHALL reject the subscription request if a client requests an unsupported channel via the backport-channel-type extension" href="rtm_requirements.html#requirement-507">requirement-507</a> | [308: Error: Create a Subscription - rest-hook - unsupported backport-channel-type](rtm_test_cases.html#testcase-308) |
| <a title="529: Consent Administration Service SHALL be able to read values in the backport-filter-criteria extension" href="rtm_requirements.html#requirement-529">requirement-529</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="530: Consent Administration Service SHALL be able to apply filters as described by any Subscription Topics the server advertises support for" href="rtm_requirements.html#requirement-530">requirement-530</a> | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="531: Consent Administration Service SHALL reject the subscription request if any filters are unsupported" href="rtm_requirements.html#requirement-531">requirement-531</a> | [309: Error: Create a Subscription - rest-hook - unsupported filter](rtm_test_cases.html#testcase-309) |
| <a title="533: Consent Administration Service SHALL be able to read values in the backport-payload-content extension" href="rtm_requirements.html#requirement-533">requirement-533</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| <a title="534: Consent Administration Service SHALL include information in notifications as described in this guide based on the value of the backport-payload-content extension" href="rtm_requirements.html#requirement-534">requirement-534</a> | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| <a title="535: Consent Administration Service SHALL reject the subscription request if a client asks for a content level the server does not intend to support (e.g., does not meet security requirements)" href="rtm_requirements.html#requirement-535">requirement-535</a> | [310: Error: Create a Subscription - rest-hook - unsupported content level](rtm_test_cases.html#testcase-310) |
| <a title="563: Consent Administration Service SHALL be able to generate a valid and correct R4 Backported R5 SubscriptionStatus resource for each notification" href="rtm_requirements.html#requirement-563">requirement-563</a> | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="538: Consent Administration Service SHALL be able to read values in Subscription.criteria for subscription topics referenced by it" href="rtm_requirements.html#requirement-538">requirement-538</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| <a title="539: Consent Administration Service SHALL reject the subscription request if it does not support a requested topic or will not honor the subscription otherwise" href="rtm_requirements.html#requirement-539">requirement-539</a> | [311: Error: Create a Subscription - rest-hook - unsupported topic](rtm_test_cases.html#testcase-311) |
| **Coverage** | **95.24%** |
{: .grid }

</div>
</div>

<b><span style="background-color: lightyellow">83.33%</span>&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#conformance-client-detail" aria-expanded="false">Requirements-conformance-client</a></b>

<div class="collapse" id="conformance-client-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="566: Consent Client SHOULD NOT use cross version extensions on R4 subscriptions to describe any elements also described by this guide" href="rtm_requirements.html#requirement-566">requirement-566</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| <a title="516: Consent Client MAY support the backport-channel-type extension" href="rtm_requirements.html#requirement-516">requirement-516</a> | n/a |
| <a title="532: Consent Client SHALL be able to write values in the backport-filter-criteria extension" href="rtm_requirements.html#requirement-532">requirement-532</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| <a title="536: Consent Client SHALL be able to write values in the backport-payload-content extension" href="rtm_requirements.html#requirement-536">requirement-536</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| <a title="564: Consent Client SHALL be able to process a valid R4 Backported R5 SubscriptionStatus resource without errors" href="rtm_requirements.html#requirement-564">requirement-564</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
|  | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
|  | [266: Operation: Get Subscription Status](rtm_test_cases.html#testcase-266) |
| <a title="540: Consent Client SHALL be able to write subscription topic URLs in Subscription.criteria" href="rtm_requirements.html#requirement-540">requirement-540</a> | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| **Coverage** | **83.33%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser-detail" aria-expanded="false">Requirements-subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser</a></b>

<div class="collapse" id="subscriptiontopic-fastconsentsubscriptiontopic-client-admin-ser-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="596: SubscriptionTopic FASTConsentSubscriptionTopic" href="rtm_requirements.html#requirement-596">requirement-596</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#structure-definitions-client-admin-service-detail" aria-expanded="false">Requirements-structure-definitions-client-admin-service</a></b>

<div class="collapse" id="structure-definitions-client-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="464: StructureDefinition FileConsentParameters" href="rtm_requirements.html#requirement-464">requirement-464</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="70: The FileConsent operation consent input parameter SHALL be 1..1 and conform to the FASTConsent profile" href="rtm_requirements.html#requirement-70">requirement-70</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="430: The FileConsent operation document input parameter SHALL be 1..1 and conform to either the us-core-questionnaireresponse or FASTDocumentReference profile" href="rtm_requirements.html#requirement-430">requirement-430</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="469: StructureDefinition RevokeConsentParameters" href="rtm_requirements.html#requirement-469">requirement-469</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="441: The RevokeConsent operation consent input parameter SHALL be 1..1 and conform to the FASTConsent profile" href="rtm_requirements.html#requirement-441">requirement-441</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="448: The RevokeConsent operation patient input parameter SHALL be 1..1 and conform to the us-core-patient profile" href="rtm_requirements.html#requirement-448">requirement-448</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="443: The RevokeConsent operation document input parameter SHALL be 0..1 and conform to either the us-core-questionnaireresponse or FASTDocumentReference profile" href="rtm_requirements.html#requirement-443">requirement-443</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="470: StructureDefinition RecordDisclosureParameters" href="rtm_requirements.html#requirement-470">requirement-470</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="452: The RecordDisclosure operation disclosure input parameter SHALL be 1..1 and conform to the 	FASTConsentAuditEvent profile" href="rtm_requirements.html#requirement-452">requirement-452</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="450: The RecordDisclosure operation consent input parameter SHALL be 1..1 and conform to the FASTConsent profile" href="rtm_requirements.html#requirement-450">requirement-450</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="477: StructureDefinition FASTSubscription" href="rtm_requirements.html#requirement-477">requirement-477</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| <a title="595: StructureDefinition BackportSubscription" href="rtm_requirements.html#requirement-595">requirement-595</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| <a title="597: StructureDefinition FASTConsent" href="rtm_requirements.html#requirement-597">requirement-597</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| <a title="599: StructureDefinition FASTDocumentReference" href="rtm_requirements.html#requirement-599">requirement-599</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| <a title="601: StructureDefinition FASTReference" href="rtm_requirements.html#requirement-601">requirement-601</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| <a title="598: StructureDefinition FASTConsentAuditEvent" href="rtm_requirements.html#requirement-598">requirement-598</a> | [140: Validate FHIR resources](rtm_test_cases.html#testcase-140) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#conformance-client-admin-service-detail" aria-expanded="false">Requirements-conformance-client-admin-service</a></b>

<div class="collapse" id="conformance-client-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="562: Notification bundles SHALL contain a FHIR R4 Parameters resource, conforming to the R4 Backported R5 SubscriptionStatus profile, as the first entry" href="rtm_requirements.html#requirement-562">requirement-562</a> | [265: Notify for a Subscription - rest-hook](rtm_test_cases.html#testcase-265) |
| <a title="537: Subscription.criteria SHALL contain the canonical URL for the Subscription Topic" href="rtm_requirements.html#requirement-537">requirement-537</a> | [199: Read a Subscription](rtm_test_cases.html#testcase-199) |
|  | [232: Workflow: Create a Subscription - rest-hook](rtm_test_cases.html#testcase-232) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#workflow-client-admin-service-detail" aria-expanded="false">Requirements-workflow-client-admin-service</a></b>

<div class="collapse" id="workflow-client-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="541: Informative: Consent Client and Consent Administration Service generally follow the subscription workflow for R4 systems in section 2.3.3" href="rtm_requirements.html#requirement-541">requirement-541</a> | [100: Workflow: Consent subscription and notification](rtm_test_cases.html#testcase-100) |
|  | [303: Workflow: Consent subscription and notification - no filters](rtm_test_cases.html#testcase-303) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#search-parameters-client-admin-service-detail" aria-expanded="false">Requirements-search-parameters-client-admin-service</a></b>

<div class="collapse" id="search-parameters-client-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="472: SearchParameter FASTConsentController" href="rtm_requirements.html#requirement-472">requirement-472</a> | [144: Search for Consent by FASTConsentController - JSON](rtm_test_cases.html#testcase-144) |
|  | [145: Search for Consent by FASTConsentController - XML](rtm_test_cases.html#testcase-145) |
| <a title="473: SearchParameter FASTConsentGrantee" href="rtm_requirements.html#requirement-473">requirement-473</a> | [148: Search for Consent by FASTConsentGrantee - JSON](rtm_test_cases.html#testcase-148) |
|  | [149: Search for Consent by FASTConsentGrantee - XML](rtm_test_cases.html#testcase-149) |
| <a title="474: SearchParameter FASTConsentManager" href="rtm_requirements.html#requirement-474">requirement-474</a> | [150: Search for Consent by FASTConsentManager - JSON](rtm_test_cases.html#testcase-150) |
|  | [151: Search for Consent by FASTConsentManager - XML](rtm_test_cases.html#testcase-151) |
| <a title="475: SearchParameter FASTConsentOrganizationId" href="rtm_requirements.html#requirement-475">requirement-475</a> | [152: Search for Consent by FASTConsentOrganizationId - JSON](rtm_test_cases.html#testcase-152) |
|  | [153: Search for Consent by FASTConsentOrganizationId - XML](rtm_test_cases.html#testcase-153) |
| <a title="476: SearchParameter FASTConsentPatientId" href="rtm_requirements.html#requirement-476">requirement-476</a> | [156: Search for Consent by FASTConsentPatientId - JSON](rtm_test_cases.html#testcase-156) |
|  | [157: Search for Consent by FASTConsentPatientId - XML](rtm_test_cases.html#testcase-157) |
| <a title="471: SearchParameter FASTAuditEventConsent" href="rtm_requirements.html#requirement-471">requirement-471</a> | [162: Search for AuditEvent by FASTAuditEventConsent - JSON](rtm_test_cases.html#testcase-162) |
|  | [163: Search for AuditEvent by FASTAuditEventConsent - XML](rtm_test_cases.html#testcase-163) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

<b>100.00%&nbsp;<a title="Click to Open or Close Details" data-toggle="collapse" data-target="#extended-operations-client-admin-service-detail" aria-expanded="false">Requirements-extended-operations-client-admin-service</a></b>

<div class="collapse" id="extended-operations-client-admin-service-detail">
<div class="card card-body" style="padding:10px" markdown="1">

| **Requirement** | **Test Case(s)** |
| <a title="463: OperationDefinition FileConsent" href="rtm_requirements.html#requirement-463">requirement-463</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="133: The FileConsent operation is invoked as [base]/Consent/$fileConsent" href="rtm_requirements.html#requirement-133">requirement-133</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="134: The FileConsent operation input parameters SHALL conform to the FileConsentParameters profile" href="rtm_requirements.html#requirement-134">requirement-134</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="135: The FileConsent operation consent input parameter SHALL be 1..1 and a Consent resource" href="rtm_requirements.html#requirement-135">requirement-135</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="166: The FileConsent operation document input parameter SHALL be 1..1 and any resource" href="rtm_requirements.html#requirement-166">requirement-166</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="168: The FileConsent operation return output parameter SHALL be 0..1 and be an OperationOutcome" href="rtm_requirements.html#requirement-168">requirement-168</a> | [68: Operation: File a Consent](rtm_test_cases.html#testcase-68) |
| <a title="466: OperationDefinition RevokeConsent" href="rtm_requirements.html#requirement-466">requirement-466</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="438: The RevokeConsent operation is invoked as [base]/Consent/$revokeConsent" href="rtm_requirements.html#requirement-438">requirement-438</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="439: The RevokeConsent operation input parameters SHALL conform to the RevokeConsentParameters profile" href="rtm_requirements.html#requirement-439">requirement-439</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="440: The RevokeConsent operation consent input parameter SHALL be 1..1 and conform to the FASTConsent profile" href="rtm_requirements.html#requirement-440">requirement-440</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="447: The RevokeConsent operation patient input parameter SHALL be 1..1 and conform to the us-core-patient profile" href="rtm_requirements.html#requirement-447">requirement-447</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="442: The RevokeConsent operation document input parameter SHALL be 0..1 and any resource" href="rtm_requirements.html#requirement-442">requirement-442</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="444: The RevokeConsent operation return output parameter SHALL be 0..1 and be an OperationOutcome" href="rtm_requirements.html#requirement-444">requirement-444</a> | [70: Operation: Revoke a Consent](rtm_test_cases.html#testcase-70) |
| <a title="467: OperationDefinition RecordDisclosure" href="rtm_requirements.html#requirement-467">requirement-467</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="445: The RecordDisclosure operation is invoked as [base]/AuditEvent/$recordDisclosure" href="rtm_requirements.html#requirement-445">requirement-445</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="446: The RecordDisclosure operation input parameters SHALL conform to the RecordDisclosureParameters profile" href="rtm_requirements.html#requirement-446">requirement-446</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="451: The RecordDisclosure operation disclosure input parameter SHALL be 1..1 and an AuditEvent resource" href="rtm_requirements.html#requirement-451">requirement-451</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="449: The RecordDisclosure operation consent input parameter SHALL be 1..1 and conform to the FASTConsent profile" href="rtm_requirements.html#requirement-449">requirement-449</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| <a title="453: The RecordDisclosure operation return output parameter SHALL be 0..1 and be an OperationOutcome" href="rtm_requirements.html#requirement-453">requirement-453</a> | [69: Operation: Record a Disclosure](rtm_test_cases.html#testcase-69) |
| **Coverage** | **100.00%** |
{: .grid }

</div>
</div>

