
### Package File

The following package file includes an NPM package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and urls in the IG, etc defined as part of this version of the Implementation Guides. This file should be the first choice whenever generating any implementation artifacts since it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation. See the overview on [validating FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html):

* [Conformance Package](package.tgz)

### Downloadable Copy of this Specification

A downloadable version of this IG is available so it can be hosted locally:

* [Downloadable Copy](full-ig.zip)

### Testing Package

The HL7 FHIR IG Publisher tool does not currently produce a "testing" package. The following links are to custom generated test package archives using a local build of the IG Publisher tool. The TestScript resources are in the specified format and all other fixture resources are in both XML and JSON.

- [XML Test Artifacts(compressed folder)](r4-testpackage-xml.zip)
- [JSON Test Artifacts(compressed folder)](r4-testpackage-json.zip)

### Examples

All the examples in this Implementation Guide are available for download:

- [XML Examples(compressed folder)](examples.xml.zip)
- [JSON Examples(compressed folder)](examples.json.zip)
